package jp.ac.titech.sharp4k.cuten;

import jp.ac.titech.sharp4k.cuten.sampletask.ECCTask;
import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Toast;

public class ECCActivity extends Activity implements ResultSender,
		OnClickListener {
	private BaseApp taskApp;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		taskApp = new ECCTask();
		taskApp.setSender(this);
		taskApp.setCloseRequester(new CloseRequester() {
			@Override
			public void close() {

			}
		});
		LinearLayout layout = new LinearLayout(this);
		layout.setOrientation(LinearLayout.VERTICAL);
		Button b = new Button(this);
		b.setOnClickListener(this);
		layout.addView(b);
		layout.addView(taskApp.createView(this, this.getResources()));
		setContentView(layout);
	}

	@Override
	public void onClick(View v) {
		taskApp.onClose();
	}

	@Override
	public void send(int[] results) {
		String str = "";
		for (Integer i : results) {
			str += i.toString() + ",";
		}
		Toast.makeText(this, str, Toast.LENGTH_SHORT).show();
	}
}