require 'test_helper'

class UsersControllerTest < ActionController::TestCase
  include Devise::TestHelpers

  setup do
    @user = FactoryGirl.create :user
  end

  test "should get profile after authentication" do
    sign_in @user
    get :profile
    assert_response :success
    assert_match @user.email, @response.body
    assert_match @user.authentication_token, @response.body
  end

  test "should reset authentication token" do
    sign_in @user
    token = @user.authentication_token
    post :reset_token, :format => :json
    assert_response :success

    json = JSON.parse @response.body
    assert json.has_key?('auth_token')
    assert_not_equal token, json['auth_token']
    assert_equal User.find(@user.id).authentication_token, json['auth_token']
  end
end
