class User < ActiveRecord::Base
  # Include default devise modules. Others available are:
  # :token_authenticatable, :confirmable,
  # :lockable, :timeoutable and :omniauthable
  devise :database_authenticatable, :registerable,
         :recoverable, :rememberable, :trackable, :validatable

  devise :token_authenticatable
  before_save :ensure_authentication_token

  # Setup accessible (or protected) attributes for your model
  attr_accessible :email, :password, :password_confirmation, :remember_me
  attr_accessible :student_number
  # attr_accessible :title, :body

  has_many :achievements
  belongs_to :teacher
  attr_accessible :teacher_id

  validate :validates_student_or_teacher
  STUDENT_NUMBER_FORMAT = /\A[0-9A-Z]+\z/

  include JsonWithoutTimestamps

  def validates_student_or_teacher
    if student_number.blank?
      if teacher.nil?
        errors.add :student_number, 'is blank'
      end
    else
      if student_number !~ STUDENT_NUMBER_FORMAT
        errors.add :student_number, 'is invalid format'
      end
    end
  end
end
