/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Application;
import android.content.Context;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import roboguice.inject.ContextScope;
import roboguice.inject.InjectPreference;
import roboguice.inject.Nullable;

public class PreferenceListener
implements TypeListener {
    protected ArrayList<PreferenceMembersInjector<?>> preferencesForInjection = new ArrayList();
    protected Provider<Context> contextProvider;
    protected Application application;
    protected ContextScope scope;

    public PreferenceListener(Provider<Context> contextProvider, Application application, ContextScope scope) {
        this.contextProvider = contextProvider;
        this.application = application;
        this.scope = scope;
    }

    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
        for (Class c = typeLiteral.getRawType(); c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(InjectPreference.class)) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new UnsupportedOperationException("Preferences may not be statically injected");
                }
                typeEncounter.register(new PreferenceMembersInjector(field, this.contextProvider, field.getAnnotation(InjectPreference.class), this.scope));
            }
        }
    }

    public void registerPreferenceForInjection(PreferenceMembersInjector<?> injector) {
        this.preferencesForInjection.add(injector);
    }

    public void injectPreferenceViews() {
        for (int i = this.preferencesForInjection.size() - 1; i >= 0; --i) {
            this.preferencesForInjection.remove(i).reallyInjectMembers();
        }
    }

    class PreferenceMembersInjector<T>
    implements MembersInjector<T> {
        protected Field field;
        protected Provider<Context> contextProvider;
        protected InjectPreference annotation;
        protected ContextScope scope;
        protected WeakReference<T> instanceRef;

        public PreferenceMembersInjector(Field field, Provider<Context> contextProvider, InjectPreference annotation, ContextScope scope) {
            this.field = field;
            this.annotation = annotation;
            this.contextProvider = contextProvider;
            this.scope = scope;
        }

        public void injectMembers(T instance) {
            this.instanceRef = new WeakReference<T>(instance);
            PreferenceListener.this.registerPreferenceForInjection(this);
        }

        public void reallyInjectMembers() {
            Object instance = this.instanceRef.get();
            if (instance == null) {
                return;
            }
            Preference value = null;
            try {
                value = ((PreferenceActivity)this.contextProvider.get()).findPreference((CharSequence)this.annotation.value());
                if (value == null && Nullable.notNullable(this.field)) {
                    throw new NullPointerException(String.format("Can't inject null value into %s.%s when field is not @Nullable", this.field.getDeclaringClass(), this.field.getName()));
                }
                this.field.setAccessible(true);
                this.field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException f) {
                throw new IllegalArgumentException(String.format("Can't assign %s value %s to %s field %s", value != null ? value.getClass() : "(null)", value, this.field.getType(), this.field.getName()));
            }
        }
    }
}

