/*
 * Decompiled with CFR 0.152.
 */
package roboguice.event;

import android.content.Context;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import roboguice.event.EventListener;
import roboguice.event.eventListener.ObserverMethodListener;
import roboguice.inject.ContextSingleton;

@ContextSingleton
public class EventManager {
    @Inject
    protected Context context;
    protected Map<Class<?>, Set<EventListener<?>>> registrations = new HashMap();

    public <T> void registerObserver(Class<T> event, EventListener listener) {
        Set<EventListener<Object>> observers = this.registrations.get(event);
        if (observers == null) {
            observers = Collections.synchronizedSet(new LinkedHashSet());
            this.registrations.put(event, observers);
        }
        observers.add(listener);
    }

    public <T> void registerObserver(Object instance, Method method, Class<T> event) {
        this.registerObserver(event, new ObserverMethodListener(instance, method));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregisterObserver(Class<T> event, EventListener<T> listener) {
        Set<EventListener<?>> observers = this.registrations.get(event);
        if (observers == null) {
            return;
        }
        Set<EventListener<?>> set = observers;
        synchronized (set) {
            Iterator<EventListener<?>> iterator = observers.iterator();
            while (iterator.hasNext()) {
                EventListener<?> registeredListener = iterator.next();
                if (registeredListener != listener) continue;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregisterObserver(Object instance, Class<T> event) {
        Set<EventListener<?>> observers = this.registrations.get(event);
        if (observers == null) {
            return;
        }
        Set<EventListener<?>> set = observers;
        synchronized (set) {
            Iterator<EventListener<?>> iterator = observers.iterator();
            while (iterator.hasNext()) {
                ObserverMethodListener observer;
                EventListener<?> listener = iterator.next();
                if (!(listener instanceof ObserverMethodListener) || (observer = (ObserverMethodListener)listener).getInstance() != instance) continue;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(Object event) {
        Set<EventListener<?>> observers = this.registrations.get(event.getClass());
        if (observers == null) {
            return;
        }
        Set<EventListener<?>> set = observers;
        synchronized (set) {
            for (EventListener<?> observer : observers) {
                observer.onEvent(event);
            }
        }
    }

    public void destroy() {
        for (Map.Entry<Class<?>, Set<EventListener<?>>> e : this.registrations.entrySet()) {
            e.getValue().clear();
        }
        this.registrations.clear();
    }
}

