package jp.co.epson.watch.plaWasabi.test.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

import jp.co.epson.watch.plaWasabi.service.ZifileService;

import org.seasar.extension.unit.S2TestCase;

/**
 * {@link ZifileService}のテストクラスです。
 * 
 * @author S2JDBC-Gen
 */
public class ZifileServiceTest extends S2TestCase {

  private ZifileService zifileService;

  /**
   * 事前処理をします。
   * 
   * @throws Exception
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    include("app.dicon");
  }

  /**
   * {@link #zifileService}が利用可能であることをテストします。
   * 
   * @throws Exception
   */
  public void testAvailable() throws Exception {
    assertNotNull(zifileService);
  }

  public void testPersist() throws IOException {
    URL fileUrl = Thread.currentThread().getContextClassLoader().getResource("5R66-SBLA032.jpg");
    File file = new File(fileUrl.getFile());
    byte[] fileByte = new byte[(int) file.length()];
    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
    bis.read(fileByte);

    this.zifileService.persist("5R66", "080000", fileByte);

  }

}