/**
 * 
 * StraformX
 * SqlImporter(DB参照)APIを利用するサンプル
 *
 */

package jp.co.epson.watch.plaWasabi.stxsample;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.fit.stx.servercomponent.core.SQLImporter;
import jp.co.fit.stx.servercomponent.core.SQLImporterIF;

public class SqlImporterSample extends HttpServlet {
  private static final long serialVersionUID = -6748482584839126981L;
  private String currentDir = "";
  private String dataDir = "";
  private String vrq = "search_text.vrq"; // VRQファイル名
  private String datapath = "/WEB-INF/query";
  private String htmlFile = "search_text_i.htm";
  private String userid = "sa"; // DBユーザ名
  private String password = "wingarc"; // DBパスワード

  @SuppressWarnings("unchecked")
  protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException,
      IOException {
    // ベースディレクトリの設定
    ServletContext sc = getServletConfig().getServletContext();
    currentDir = sc.getRealPath("/") + File.separator;
    dataDir = sc.getRealPath(datapath) + File.separator; // データxmlの格納ディレクトリの誌・

    // 文字コードのセット
    req.setCharacterEncoding("MS932");

    // 結果出力をresponseに設定して、DB参照を呼ｄ双し
    sqlimportTest((HashMap) req.getParameterMap(), res.getOutputStream());
  }

  /**
   * DB参照した結果をHTMLに差し込みOutputStreamに書き出す
   * 
   * @param variables
   * @param out
   * @return
   * @throws IOException
   */
  @SuppressWarnings("unchecked")
  private void sqlimportTest(HashMap variables, OutputStream out) {
    // サンプルDBへのコネクション生成
    Connection con = getJDBCConnect("com.microsoft.sqlserver.jdbc.SQLServerDriver",
        "jdbc:sqlserver://localhost:1433;DatabaseName=sample", userid, password);

    FileInputStream html = null;
    try {
      // テンプレートHTML
      html = new FileInputStream(currentDir + htmlFile);

      if (con != null) {
        // DB参照用API
        SQLImporterIF sql = new SQLImporter();
        // コネクションのセット
        sql.setConnection(con);
        // API呼ｄ双し
        int rv = sql.importer(SQLImporterIF.IMPORT_FOR_INPUT, dataDir + vrq, variables, html, out);
        if (rv == 0) {
          System.out.println("SqlImporter OK.");
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      if (con != null) {
        try {
          con.close();
        } catch (SQLException e) {
          e.printStackTrace();
        }
      }

      try {
        if (html != null)
          html.close();
        out.close();
      } catch (Exception e) {
        e.printStackTrace();
      }
    }
  }

  /**
   * JDBC接続でConnectionを生成する
   * 
   * @return Connection
   */
  public Connection getJDBCConnect(String className, String url, String userid, String password) {
    Connection rv = null;
    try {
      Class.forName(className);
      rv = DriverManager.getConnection(url, userid, password);
    } catch (NullPointerException e) {
      e.printStackTrace();
    } catch (ClassNotFoundException e) {
      e.printStackTrace();
    } catch (SQLException e) {
      e.printStackTrace();
    }
    return rv;
  }
}
