package jp.co.epson.watch.plaWasabi.service.svf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;

import javax.servlet.ServletContext;

import jp.co.fit.UCXSingle.UCXSingle;
import jp.co.fit.vfreport.Vrw32;

import org.apache.log4j.Logger;
import org.seasar.framework.container.annotation.tiger.Binding;

public class PDFService implements STX2SVF {

  @Binding
  private ServletContext context;

  private static final Logger log = Logger.getLogger(PDFService.class);

  @Override
  public int previewPDF(Map<String, Object> valueMap, OutputStream pdfOs, String formName) {
    int ret = 0;
    Vrw32 svf = new Vrw32();
    ret = svf.VrInit();
    this.debug("VrInit()", ret);
    ret = svf.VrSetPrinter("", "PDF");
    this.debug("VrSetPrinter()", ret);
    ret = svf.VrSetSpoolFileStream(pdfOs);
    this.debug("VrSetSpoolFileStream()", ret);
    ret = svf.VrSetForm(this.context.getRealPath(formName), 3);
    this.debug("VrSetForm()", ret);

    for (String key : valueMap.keySet()) {
      Object val = valueMap.get(key);
      if (val != null) {
        ret = svf.VrsOut(key, val.toString());
        this.debug("VrsOut()", ret);
      }
    }
    ret = svf.VrEndRecord();
    this.debug("VrEndRecord()", ret);
    ret = svf.VrPrint();
    this.debug("VrPrint()", ret);
    int contentLength = svf.VrQuit();
    this.debug("VrQuit()", contentLength);

    return contentLength;

  }

  private void debug(String prefix, int ret) {
    if (ret != 0) {
      log.debug(prefix + ":" + ret);
    }
  }

  @Override
  public int previewPDF(InputStream is, OutputStream pdfOs, String formName, String host, int port,
      String settingName) throws Exception {

    String uuid = UUID.randomUUID().toString();
    // TODO XMLとPDFのパスがハードコーディング
    String datafile = "C:\\" + uuid + ".xml";
    String resultFileName = "C:\\" + uuid + ".pdf";
    File file = new File(datafile);
    this.createFile(is, file);

    // UCXSingleの生成
    UCXSingle ucs = new UCXSingle();

    // Universal Connect/X サーバのホスト名、IP アドレスを指定します。
    ucs.setUniConXServer(host, port);

    // 動作設定名を指定します。
    ucs.setSettingName(settingName);

    // データファイル名を指定します。
    ucs.setSourceName(datafile);

    // 処理が正常終了した場合に、データファイルを削除します。
    ucs.setUndeleteSourceFile(false);

    // 処理が異常終了した場合に、データファイルを削除しません。
    ucs.setUndeleteSourceFileIfError(true);

    // 生成される出力ファイル名を指定します。
    ucs.setResultFileName(resultFileName);

    // 設定した動作設定に従って処理を実行します。
    ucs.doTransaction();

    // UCXSingleとUniversal Connect/Xのエラーチェック
    int ucxResult = ucs.getUniConXResult();
    int singleResult = ucs.getUCXSingleResult();

    if (ucxResult < 0)
      throw new Exception("UCX ErrorCode is [" + ucxResult + "]");
    if (singleResult < 0)
      throw new Exception("UCXSsingle ErrorCode is [" + singleResult + "]");

    int ret = 0;
    try {
      FileInputStream in = new FileInputStream(resultFileName);
      byte[] buf = new byte[1024];
      int n = 0;
      while ((n = in.read(buf)) != -1) {
        pdfOs.write(buf);
        ret += n;
      }
      in.close();
    } catch (IOException e) {
      System.out.println(e);
    }
    new File(resultFileName).delete();

    return ret;
  }

  private void createFile(InputStream is, File file) throws IOException {
    byte[] buffer = new byte[1024];
    int length = 0;
    FileOutputStream fos = null;
    try {
      fos = new FileOutputStream(file);

      while ((length = is.read(buffer)) >= 0) {
        fos.write(buffer, 0, length);
      }

      fos.close();
      fos = null;
    } finally {
      if (fos != null) {
        try {
          fos.close();
        } catch (IOException e) {
        }
      }
    }
  }

}
