package jp.co.epson.watch.plaWasabi.service;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import jp.co.epson.watch.plaWasabi.commons.Constants;
import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;
import jp.co.epson.watch.plaWasabi.converter.prmMapKey.PrmConverter;
import jp.co.epson.watch.plaWasabi.dto.formConfig.Action;
import jp.co.epson.watch.plaWasabi.dto.formConfig.ActionQuery;
import jp.co.epson.watch.plaWasabi.dto.formConfig.Form;
import jp.co.epson.watch.plaWasabi.dto.formConfig.PdfForm;
import jp.co.epson.watch.plaWasabi.dto.formConfig.QueryParam;
import jp.co.epson.watch.plaWasabi.service.excel.ExcelService;
import jp.co.epson.watch.plaWasabi.service.excel.FieldDef;
import jp.co.epson.watch.plaWasabi.service.excel.FieldsDef;
import jp.co.epson.watch.plaWasabi.service.schema.CacheManager;
import jp.co.epson.watch.plaWasabi.service.schema.DbColumnDef;
import jp.co.epson.watch.plaWasabi.service.straForm.StraFormService;
import jp.co.epson.watch.plaWasabi.service.svf.PDFService;
import jp.co.fit.stx.servercomponent.core.XmlImporter;

import org.apache.commons.lang.StringUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;

public class LogicService {

  @Binding
  private S2Container container;

  @Binding
  private StraFormService straFormService;

  @Binding
  private DbService dbService;

  @Binding("schema_oracle_cacheManagerService")
  private CacheManager cacheManagerService;

  @Binding
  private ExcelService excelService;

  @Binding
  private PDFService pdfService;

  public void renderEmptyHtml(Action action, OutputStream os) {
    LogicServiceDto dto = this.getSearchCond(action);

    // 画面描画
    this.straFormService.renderHtml(dto.importType, null, dto.htmlFile, dto.xslFile, dto.erases,
        dto.labels, os);

  }

  @SuppressWarnings("unchecked")
  public Map search(Action action, Map<String, String> paramMap, OutputStream os) {
    LogicServiceDto dto = this.getSearchCond(action);

    // 画面表示用Map
    Map<String, String[]> res = new HashMap<String, String[]>();

    // 検索条件を画面表示用Mapにセットする
    PrmConverter condConv = (PrmConverter) this.container
        .getComponent(Constants.DEFAULT_PRM_CONVERTER);
    res.putAll(condConv.convert(paramMap));

    // 検索結果(更新時に他者が変更していないか確認するための元ねた)
    Map resMap = new HashMap();

    for (String q : action.getQueryMap().keySet()) {
      ActionQuery actionQuery = action.getQueryMap().get(q);
      String[] searchConditionArray = this.searchConditionArray(actionQuery, paramMap);
      // 検索
      List<Map> resList = this.dbService.selectBySql(actionQuery.getQuery().getQuery(),
          searchConditionArray);

      String prmConverterName = StringUtils.isBlank(actionQuery.getPrmConverter()) ? Constants.DEFAULT_PRM_CONVERTER
          : actionQuery.getPrmConverter();
      PrmConverter dataConv = (PrmConverter) this.container.getComponent(prmConverterName);

      // 検索結果を画面表示用Mapにセットする
      Map<String, String[]> rowMap = dataConv.convert(resList);
      res.putAll(rowMap);
      resMap.putAll(this.straFormService.convertParamMap2Map(rowMap));

    }
    // 画面描画
    this.straFormService.renderHtml(dto.importType, res, dto.htmlFile, dto.xslFile, dto.erases,
        dto.labels, os);

    return resMap;
  }

  @SuppressWarnings("unchecked")
  public void excel(Action action, Map<String, String> paramMap, OutputStream os) {

    FieldsDef fieldsDef = new FieldsDef();
    int colNum = 0;
    for (String fld : action.getExcelForm().getFields()) {
      FieldDef def = new FieldDef();
      def.id = fld;
      DbColumnDef colDef = this.cacheManagerService.getColumn(fld);
      def.name = colDef.getComment();
      fieldsDef.addField(colNum++, def);
    }

    List<Map> resList = new ArrayList<Map>();
    for (String q : action.getQueryMap().keySet()) {
      ActionQuery actionQuery = action.getQueryMap().get(q);
      String[] searchCondArray = this.searchConditionArray(actionQuery, paramMap);
      resList
          .addAll(this.dbService.selectBySql(actionQuery.getQuery().getQuery(), searchCondArray));
    }

    this.excelService.createXlsBook(fieldsDef, resList, os);

  }

  @SuppressWarnings("unchecked")
  public void pdf(Action action, Map<String, String> paramMap, HttpServletResponse response) {
    try {
      PdfForm pdfForm = action.getPdfForm();

      // StringBuilder imageUrl = new StringBuilder();
      // imageUrl.append("http://");
      // imageUrl.append(request.getLocalAddr());
      // imageUrl.append(":");
      // imageUrl.append(request.getLocalPort());
      // imageUrl.append("/plaWasabiWeb");
      // imageUrl.append("/stxForm/Image");
      // imageUrl.append("?cal=" + cal);
      // imageUrl.append("&plan=" + plan);

      // map.put("ImageArea",
      // "http://133.154.15.90/bc/harmony/wp_topics/naka2.jpg");
      // map.put("ImageArea", imageUrl.toString());
      // map.put("ImageArea",
      // "http://163.141.110.219:8380/plaWasabiWeb/img/noimage.jpg");

      Map resMap = null;
      for (String q : action.getQueryMap().keySet()) {
        ActionQuery actionQuery = action.getQueryMap().get(q);
        String[] searchConditionArray = this.searchConditionArray(actionQuery, paramMap);
        // 検索
        resMap = this.dbService.selectUniqueBySql(actionQuery.getQuery().getQuery(),
            searchConditionArray);
      }

      String pdfFileName = this.getPdfOutputFileName(pdfForm, resMap);
      response.setHeader("Content-Disposition", "attachment;filename=" + pdfFileName);
      response.setHeader("Cache-Control", "private");
      response.setContentType("application/pdf");

      try {
        OutputStream os = response.getOutputStream();
        this.pdfService.previewPDF(resMap, os, pdfForm.getFormFile());
        os.flush();
        os.close();

      } catch (IOException e) {
        throw new WasabiRuntimeException(e);
      }

    } catch (Exception e) {
      throw new WasabiRuntimeException(e);
    }

  }

  public void listDelete(Action action, String[] delIdArr) {
    for (String id : delIdArr) {
      this.dbService.deleteBySql(action.getDeleteQuery().getQuery(), id);
    }
  }

  private LogicServiceDto getSearchCond(Action action) {
    LogicServiceDto dto = new LogicServiceDto();
    Form form = action.getForm();
    dto.importType = action.getImportType();
    if (dto.importType == XmlImporter.IMPORT_FOR_INPUT) {
      dto.htmlFile = form.getHtmliFile();
    } else if (dto.importType == XmlImporter.IMPORT_FOR_REFER) {
      dto.htmlFile = form.getHtmlrFile();
    }
    dto.xslFile = form.getXslFile();
    dto.erases = form.getEraseFields().toArray(new String[form.getEraseFields().size()]);
    dto.labels = form.getLabelFields().toArray(new String[form.getLabelFields().size()]);

    return dto;
  }

  private String[] searchConditionArray(final ActionQuery actionQuery,
      Map<String, String> searchCondMap) {
    String[] searchCondArray = new String[actionQuery.getQueryParams().size()];
    int i = 0;
    for (QueryParam param : actionQuery.getQueryParams()) {
      String op = QueryParam.COMPARE_FUZZY.equals(param.getCompare()) ? "%" : "";
      searchCondArray[i++] = searchCondMap.get(param.getId()) + op;
    }
    return searchCondArray;
  }

  private String getPdfOutputFileName(PdfForm pdfForm, Map<String, String> requestParamater) {
    StringBuilder fileName = new StringBuilder();
    for (String param : pdfForm.getFileNameParams()) {
      if (fileName.length() != 0) {
        fileName.append("-");
      }
      fileName.append(requestParamater.get(param));
    }
    return fileName + ".pdf";
  }

  private class LogicServiceDto {
    private int importType;

    private String htmlFile;

    private String xslFile;

    private String[] erases;

    private String[] labels;

  }

}
