package jp.co.epson.watch.plaWasabi.interceptor;

import java.lang.reflect.AccessibleObject;
import java.util.Date;
import java.util.regex.Pattern;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import jp.co.epson.watch.plaWasabi.annotation.AcLog;
import jp.co.epson.watch.plaWasabi.commons.Constants;
import jp.co.epson.watch.plaWasabi.dto.formConfig.Action;
import jp.co.epson.watch.plaWasabi.dto.formConfig.FormConfig;
import jp.co.epson.watch.plaWasabi.entity.AccessLog;
import jp.co.epson.watch.plaWasabi.service.AccessLogService;
import jp.co.epson.watch.plaWasabi.service.form.FormService;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

public class AcLogInterceptor extends AbstractInterceptor {

  private static final long serialVersionUID = -277870116705100305L;

  @Resource
  private HttpServletRequest request;

  @Resource
  private AccessLogService accessLogService;

  @Resource
  private FormService formService;

  @Override
  public Object invoke(MethodInvocation inv) throws Throwable {

    AccessLog accessLog = new AccessLog();

    AccessibleObject targetMethod = inv.getStaticPart();
    if (targetMethod.isAnnotationPresent(AcLog.class)) {
      accessLog.startTime = new Date();
    }

    Object ret = inv.proceed();

    if (targetMethod.isAnnotationPresent(AcLog.class)) {
      AcLog acLog = targetMethod.getAnnotation(AcLog.class);

      Action action = this.getAction();

      accessLog.endTime = new Date();
      accessLog.userId = this.request.getRemoteUser();
      accessLog.ipAddress = this.request.getRemoteAddr();
      accessLog.aplCd = action.getAplCd();
      accessLog.aplName = action.getAplName();
      accessLog.accessType = acLog.accessType().name();

      String source = inv.getThis().getClass().getName();
      Pattern pattern = Pattern.compile("\\$\\$");
      String[] str = pattern.split(source);
      String classname = str[0];
      accessLog.className = classname + "#" + inv.getMethod().getName();

      this.accessLogService.insert(accessLog);

    }

    return ret;

  }

  /**
   * 設定ファイルからActionを取得する
   * 
   * @return
   */
  private Action getAction() {
    FormConfig config = null;
    String formId = this.request.getParameter(Constants.FORM_ID);
    if (StringUtils.isNotBlank(formId)) {
      config = this.formService.loadFormConfig(formId);
    }
    String actionId = this.request.getParameter(Constants.ACTION_ID);
    Action action = config.getActions().get(actionId);
    return action;
  }

}
