package jp.co.epson.watch.plaWasabi.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumns;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

import jp.co.epson.watch.plaWasabi.service.schema.DbColumnDef;
import jp.co.epson.watch.plaWasabi.service.schema.DbTableDef;

@Entity
public class UserTabColumns implements DbColumnDef {

  /** tableNameプロパティ */
  @Id
  @Column
  public String tableName;

  /** columnNameプロパティ */
  @Id
  @Column
  public String columnName;

  /** columnIdプロパティ */
  @Column
  public Short columnId;
  
  /** dataTypeプロパティ */
  @Column
  public String dataType;
  
  /** dataLengthプロパティ */
  @Column
  public int dataLength;
  
  /** Nullableプロパティ */
  @Column
  public char nullable;
  
  @OneToMany(mappedBy="userTabColumns")
  public List<UserConsColumns> userConsColumnsList;

  
  @ManyToOne
  @JoinColumns({
    @JoinColumn(name = "TABLE_NAME", referencedColumnName = "TABLE_NAME")}
    //@JoinColumn(name = "COLUMN_NAME", referencedColumnName = "COLUMN_NAME")}
    )
  public UserTables userTables;

  
  
  @OneToOne
  @JoinColumns({
	    @JoinColumn(name = "TABLE_NAME", referencedColumnName = "TABLE_NAME"),
	    @JoinColumn(name = "COLUMN_NAME", referencedColumnName = "COLUMN_NAME")}
	    )
  public UserColComments userColComments;
  
  
  

  @Override
  public Short getColumnId() {
    return this.columnId;
  }


  @Override
  public int getDataLength() {
    return this.dataLength;
  }


  @Override
  public String getDataType() {
    return this.dataType;
  }


  @Override
  public String getName() {
    return this.columnName.toLowerCase();
  }


  @Override
  public String getTableName() {
    return this.tableName.toLowerCase();
  }


  @Override
  public DbTableDef getTable() {
    return this.userTables;
  }


  @Override
  public boolean isPrimaryKey()
  {
    for (UserConsColumns ucc : this.userConsColumnsList)
    {
      if ('P' == ucc.userConstraints.constraintType)
      {
        return true;
      }
    }
    return false;
  }
  
  @Override
  public boolean isForeignKey()
  {
    for (UserConsColumns ucc : this.userConsColumnsList)
    {
      if ('R' == ucc.userConstraints.constraintType)
      {
        return true;
      }
    }
    return false;
  }


  @Override
  public Map<String, DbColumnDef> getForeingKey() {
    Map<String, DbColumnDef> foreignKeys
      = new HashMap<String, DbColumnDef>();
    for (UserConsColumns ucc : this.userConsColumnsList)
    {
      if ('R' == ucc.userConstraints.constraintType)
      {
        for (UserConsColumns rUcc : ucc.userConstraints.rUserConsColumnsList)
        {
        	if (ucc.position == rUcc.position)
        	{
        		foreignKeys.put(ucc.constraintName, rUcc.userTabColumns);
        		break;
        	}
        }
      }
    }
    return foreignKeys;
  }

  @Override
  public boolean isNullable() {
    return ('Y' == this.nullable);
  }


  @Override
  public String getComment() {
    return(null == this.userColComments.comments ?
    		"" : this.userColComments.comments);
  }
  
  
  /*
   @JoinColumns({
    @JoinColumn(name = "TABLE_NAME", referencedColumnName = "TABLE_NAME"),
    @JoinColumn(name = "COLUMN_NAME", referencedColumnName = "COLUMN_NAME")})
   */
  // /** kikaku2関連プロパティ */
  // @OneToOne(mappedBy = "kikaku")
  // public Kikaku2 kikaku2;
  //
  // /** kikakus関連プロパティ */
  // @OneToOne(mappedBy = "kikaku")
  // public Kikakus kikakus;
  //
  // /** skikakubList関連プロパティ */
  // @OneToMany(mappedBy = "kikaku")
  // public List<Skikakub> skikakubList;
}