package jp.co.epson.watch.plaWasabi.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * AccessLogエンティティクラス
 * 
 * @author S2JDBC-Gen
 */
@Entity
public class AccessLog {

  /** seqプロパティ */
  @Id
  @GeneratedValue(strategy = GenerationType.TABLE, generator = "generator")
  @TableGenerator(name = "generator", initialValue = 0, allocationSize = 1)
  @Column(precision = 22, nullable = false, unique = true)
  public Long seq;

    /** accessTypeプロパティ */
    @Column(length = 64, nullable = false, unique = false)
    public String accessType;

    /** startTimeプロパティ */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false, unique = false)
    public Date startTime;

    /** endTimeプロパティ */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = true, unique = false)
    public Date endTime;

    /** userIdプロパティ */
    @Column(length = 32, nullable = false, unique = false)
    public String userId;

    /** aplCdプロパティ */
    @Column(length = 32, nullable = false, unique = false)
    public String aplCd;

    /** aplNameプロパティ */
    @Column(length = 512, nullable = false, unique = false)
    public String aplName;

    /** classNameプロパティ */
    @Column(length = 512, nullable = false, unique = false)
    public String className;

    /** ipAddressプロパティ */
    @Column(length = 15, nullable = false, unique = false)
    public String ipAddress;
}