package jp.co.epson.watch.plaWasabi.dto.formConfig;

import java.util.HashMap;
import java.util.Map;

import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;

public class Action {
  private String method;

  private String aplCd;

  private String aplName;

  private FormConfig formConfig;

  /**
   * 画面ごとのimportType<br>
   * XmlImporter.IMPORT_FOR_INPUT:0、XmlImporter.IMPORT_FOR_REFER：1
   */
  private int importType;

  private Form form;

  private Query deleteQuery;

  private Map<String, ActionQuery> queryMap = new HashMap<String, ActionQuery>();

  private EntityMapping entityMapping;

  private ExcelForm excelForm;

  private PdfForm pdfForm;

  private String forward;

  public ActionQuery getPrimaryActionQuery() {
    ActionQuery actionQuery = null;
    for (String key : this.queryMap.keySet()) {
      ActionQuery q = this.queryMap.get(key);
      if (q.isPrimary()) {
        if (actionQuery == null) {
          actionQuery = q;
        } else {
          throw new WasabiRuntimeException("Primary ActionQuery is duplicative");
        }
      }
    }
    return actionQuery;
  }

  public String getMethod() {
    return method;
  }

  public void setMethod(String method) {
    this.method = method;
  }

  public String getAplCd() {
    return aplCd;
  }

  public void setAplCd(String aplCd) {
    this.aplCd = aplCd;
  }

  public String getAplName() {
    return aplName;
  }

  public void setAplName(String aplName) {
    this.aplName = aplName;
  }

  public FormConfig getFormConfig() {
    return formConfig;
  }

  public void setFormConfig(FormConfig formConfig) {
    this.formConfig = formConfig;
  }

  public int getImportType() {
    return importType;
  }

  public void setImportType(int importType) {
    this.importType = importType;
  }

  public Form getForm() {
    return form;
  }

  public void setForm(Form form) {
    this.form = form;
  }

  public Query getDeleteQuery() {
    return deleteQuery;
  }

  public void setDeleteQuery(Query deleteQuery) {
    this.deleteQuery = deleteQuery;
  }

  public Map<String, ActionQuery> getQueryMap() {
    return queryMap;
  }

  public void setQueryMap(Map<String, ActionQuery> queryMap) {
    this.queryMap = queryMap;
  }

  public EntityMapping getEntityMapping() {
    return entityMapping;
  }

  public void setEntityMapping(EntityMapping entityMapping) {
    this.entityMapping = entityMapping;
  }

  public ExcelForm getExcelForm() {
    return excelForm;
  }

  public void setExcelForm(ExcelForm excelForm) {
    this.excelForm = excelForm;
  }

  public PdfForm getPdfForm() {
    return pdfForm;
  }

  public void setPdfForm(PdfForm pdfForm) {
    this.pdfForm = pdfForm;
  }

  public String getForward() {
    return forward;
  }

  public void setForward(String forward) {
    this.forward = forward;
  }

}
