package jp.co.epson.watch.plaWasabi.dto;

import java.util.ArrayList;
import java.util.List;


/**
 * テーブル定義情報
 * 
 * @author K.Ono
 */
public class TableDef {
  
	/**
	 * テーブル定義情報ファイルの最終更新日
	 */
	protected long lastModified = 0;
	
	
  /**
   * テーブル名称
   */
  private String name = null;
  
  /**
   * 主キー
   */
  private List<String> primaryKey = null;

  /**
   * 外部参照キー(複数)
   */
  private List<ForeignKey> foreignKeys = null;
  
  /**
   * カラム
   */
  private List<Column> columns = null;
  
  
  /**
   * コンストラクタ
   */
  public TableDef()
  {
	  this.setName("");
	  this.setPrimaryKey(new ArrayList<String>());
	  this.setForeignKeys(new ArrayList<ForeignKey>());
	  this.setColumns(new ArrayList<Column>());
  }

  
	public void setName(String name) {
		this.name = name;
	}
	
	public String getName() {
		return name;
	}

	public void setPrimaryKey(List<String> primaryKey) {
		this.primaryKey = primaryKey;
	}

	public List<String> getPrimaryKey() {
		return primaryKey;
	}

	public void setForeignKeys(List<ForeignKey> foreignKeys) {
		this.foreignKeys = foreignKeys;
	}

	public List<ForeignKey> getForeignKeys() {
		return foreignKeys;
	}

	public void setColumns(List<Column> columns) {
		this.columns = columns;
	}

	public List<Column> getColumns() {
		return columns;
	}
  

}
