package jp.co.epson.watch.plaWasabi.dto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

public class ChangeDatas implements Serializable {

  private static final long serialVersionUID = -5972743716791559907L;

  private Map<String, ChangeDataElem> changeDataMap = new HashMap<String, ChangeDataElem>();

  public Map<String, String> getPersistMap() {
    Map<String, String> map = new HashMap<String, String>();

    for (String id : this.changeDataMap.keySet()) {
      ChangeDataElem elem = this.changeDataMap.get(id);
      map.put(id, elem.getNewValue());
    }

    return map;
  }

  public void put(String id, ChangeDataElem elem) {
    this.changeDataMap.put(id, elem);
  }

  public String getChangeContent() {
    StringBuilder updatedContent = new StringBuilder();
    for (String key : this.changeDataMap.keySet()) {
      ChangeDataElem changeLogElem = this.changeDataMap.get(key);
      updatedContent.append(changeLogElem);
    }

    return StringUtils.right(updatedContent.toString(), 2048);
  }

}
