package jp.co.epson.watch.plaWasabi.action.stx;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.co.epson.watch.plaWasabi.commons.Constants;
import jp.co.epson.watch.plaWasabi.dto.ChangeDataElem;
import jp.co.epson.watch.plaWasabi.dto.Conflict;
import jp.co.epson.watch.plaWasabi.dto.formConfig.Action;
import jp.co.epson.watch.plaWasabi.dto.formConfig.FormConfig;
import jp.co.epson.watch.plaWasabi.dto.formConfig.QueryParam;
import jp.co.epson.watch.plaWasabi.form.stx.SaveForm;
import jp.co.epson.watch.plaWasabi.service.DbService;
import jp.co.epson.watch.plaWasabi.service.form.FormService;
import jp.co.epson.watch.plaWasabi.service.schema.DbColumnDef;
import jp.co.epson.watch.plaWasabi.service.schema.oracle.CacheManagerService;
import jp.co.epson.watch.plaWasabi.service.straForm.StraFormService;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class SaveDispatchAction {

  @ActionForm
  @Resource
  private SaveForm saveForm;

  @Resource
  private HttpServletRequest request;

  @Resource
  private HttpSession session;

  @Resource
  private DbService dbService;

  @Resource
  private StraFormService straFormService;

  @Resource
  private CacheManagerService cacheManagerService;

  private FormConfig config;

  @Resource
  private FormService formService;

  @InitMethod
  public void init() {
    String formId = this.request.getParameter(Constants.FORM_ID);
    if (StringUtils.isNotBlank(formId)) {
      this.config = this.formService.loadFormConfig(formId);
    }
  }

  @SuppressWarnings("unchecked")
  @Execute(validator = false)
  public String dispatch() throws Exception {
    String actionId = this.request.getParameter(Constants.ACTION_ID);
    Action action = this.config.getActions().get(actionId);

    if (this.saveForm.paramMap == null || this.saveForm.paramMap.size() == 0) {
      this.saveForm.paramMap = (Map<String, String[]>) this.request.getParameterMap();
    }

    // 画面に入力した値を取得
    Map<String, String> screenMap = this.straFormService
        .convertParamMap2Map(this.saveForm.paramMap); // 画面に入力した値
    // FIXME 画面入力値をセッションに仮保存
    this.session.setAttribute(Constants.SCREEN_MAP_KEY, screenMap);

    // 画面オープン時の値を取得
    // FIXME 画面オープン時の値をセッションから仮取得
    Map<String, String> onOpenMap = (Map<String, String>) this.session
        .getAttribute(Constants.OPEN_MAP_KEY); // 画面オープン時の値

    // 前回衝突チェック時のDB値を取得
    // FIXME 前回衝突チェック時のDBをセッションから仮取得
    Map<String, String> lastDbMap = (Map<String, String>) this.session
        .getAttribute(Constants.LAST_DB_MAP_KEY); // 前回衝突チェック時のDB

    // 前回衝突チェックの調整画面にて、画面入力値を選択したフィールドを取得
    // FIXME 画面入力値を選択したフィールドをセッションから仮取得
    String[] overwrites = (String[]) this.session.getAttribute(Constants.CONF_VALID_KEY); // 画面入力値を選択したフィールド

    // 現在のDBの値を取得する為の検索キーを得る
    String[] searchPrms = new String[action.getPrimaryActionQuery().getQueryParams().size()];
    int searchPrmsCnt = 0;
    for (QueryParam prm : action.getPrimaryActionQuery().getQueryParams()) {
      searchPrms[searchPrmsCnt++] = screenMap.get(prm.getId());
    }

    boolean isSearchPrmsEmpty = true;
    for (String searchPrm : searchPrms) {
      if (StringUtils.isNotBlank(searchPrm)) {
        isSearchPrmsEmpty = false;
        break;
      }
    }

    List<Conflict> conflicts = new ArrayList<Conflict>(); // 衝突情報
    if (isSearchPrmsEmpty) {
      // 現在のDB値を取得するための検索キーが無いとき（＝新規作成のとき）
      for (String field : screenMap.keySet()) {
        String screenValue = screenMap.containsKey(field) ? screenMap.get(field) : "";
        ChangeDataElem changeDataElem = makeChangeDataElem(field, "", screenValue);
        if (changeDataElem != null) {
          this.saveForm.changeDatas.put(field, changeDataElem);
        }
      }
      return "/stx/save";

    } else {
      // 現在のDB値を取得するための検索キーがあるとき（＝更新のとき）

      // 現在のDBの値を取得
      Map<String, String> currentDbMap = this.dbService.selectUniqueBySql(action
          .getPrimaryActionQuery().getQuery().getQuery(), searchPrms); // 現在のDBの値
      // FIXME 現在のDBの値をセッションに仮保存
      this.session.setAttribute(Constants.DB_MAP_KEY, currentDbMap);

      for (String field : currentDbMap.keySet()) {
        String dbValue = currentDbMap.containsKey(field) ? currentDbMap.get(field) : "";
        String screenValue = screenMap.containsKey(field) ? screenMap.get(field) : "";
        String openValue = onOpenMap.containsKey(field) ? onOpenMap.get(field) : "";

        // 「開いたときの値」「現在のDBの値」「画面の入力値」のすべてが異なるときに、衝突が発生したとみなす
        if (!StringUtils.equals(dbValue, screenValue) && !StringUtils.equals(dbValue, openValue)
            && !StringUtils.equals(screenValue, openValue)) {

          if (overwrites != null && lastDbMap != null) {
            String currentDb = currentDbMap.get(field);
            String lastDb = lastDbMap.get(field);
            if (ArrayUtils.contains(overwrites, field) && StringUtils.equals(currentDb, lastDb)) {
              // 前回衝突チェックの調整画面にて、画面入力値を選択したフィールドであって、・・・
              // かつ
              // 前回衝突チェック時のDB値と現在のDB値が同じであれば（<-衝突調整画面が開いてから今までの間、他人が更新していない）、
              // 衝突していないものとみなす
              continue;
            }
          }

          String fieldName = this.cacheManagerService.getColumn(field).getName();
          conflicts.add(new Conflict(field, fieldName, openValue, dbValue, screenValue));
        }
      }

      if (conflicts.size() > 0) {
        // 衝突が発生した
        this.request.setAttribute("conflicts", conflicts);
        return "/stx/adjustInit?formId=" + action.getFormConfig().getId() + "&actionId="
            + action.getMethod();

      } else {
        // 衝突が発生していない
        for (String field : currentDbMap.keySet()) {
          String dbValue = currentDbMap.containsKey(field) ? currentDbMap.get(field) : "";
          String screenValue = screenMap.containsKey(field) ? screenMap.get(field) : "";
          String openValue = onOpenMap.containsKey(field) ? onOpenMap.get(field) : "";

          dbValue = dbValue == null ? "" : dbValue;
          screenValue = screenValue == null ? "" : screenValue;
          openValue = openValue == null ? "" : openValue;

          if (!StringUtils.equals(openValue, dbValue) && StringUtils.equals(openValue, screenValue)) {
            // 「画面オープン時の値」と「DB値」が異なり（<-他人が更新したことを示す）、
            // 「画面オープン時の値」と「画面入力値」が同じとき（<-自分は編集していないことを示す）、
            // 「画面入力値」に「DB値」をセットする（<-他人の更新を取り込む）
            this.saveForm.paramMap.put(field, new String[] { dbValue });
          }

          if (!StringUtils.equals(openValue, screenValue)) {
            // 「画面オープン時の値」と「画面入力値」が異なるとき（<-自分は編集したことを示す）
            ChangeDataElem changeDataElem = makeChangeDataElem(field, openValue, screenValue);
            if (changeDataElem != null) {
              this.saveForm.changeDatas.put(field, changeDataElem);
            }
          }

        }
        return "/stx/save";
      }
    }

  }

  private ChangeDataElem makeChangeDataElem(String field, String openValue, String screenValue) {
    DbColumnDef colDef = this.cacheManagerService.getColumn(field);
    ChangeDataElem changeDataElem = null;
    if (colDef != null && StringUtils.isNotBlank(colDef.getName())) {
      String fieldName = colDef.getName();
      changeDataElem = new ChangeDataElem();

      changeDataElem.setFieldId(field);
      changeDataElem.setFieldName(fieldName);
      changeDataElem.setOldValue(openValue);
      changeDataElem.setNewValue(screenValue);

    }

    return changeDataElem;

  }

}
