package jp.co.epson.watch.plaWasabi.action.stx;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import jp.co.epson.watch.plaWasabi.annotation.AcLog;
import jp.co.epson.watch.plaWasabi.annotation.AccessType;
import jp.co.epson.watch.plaWasabi.commons.Constants;
import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;
import jp.co.epson.watch.plaWasabi.dto.formConfig.Action;
import jp.co.epson.watch.plaWasabi.dto.formConfig.FormConfig;
import jp.co.epson.watch.plaWasabi.entity.ChangeLog;
import jp.co.epson.watch.plaWasabi.form.stx.SaveForm;
import jp.co.epson.watch.plaWasabi.service.ChangeLogService;
import jp.co.epson.watch.plaWasabi.service.DbService;
import jp.co.epson.watch.plaWasabi.service.form.FormService;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class SaveAction {

  @ActionForm
  @Resource
  private SaveForm saveForm;

  @Resource
  private HttpServletRequest request;

  @Resource
  private ChangeLogService changeLogService;

  @Resource
  private FormService formService;

  @Resource
  private DbService dbService;

  private FormConfig config;

  @InitMethod
  public void init() {
    String formId = this.request.getParameter(Constants.FORM_ID);
    if (StringUtils.isNotBlank(formId)) {
      this.config = this.formService.loadFormConfig(formId);
    }
  }

  @Execute(validator = false, redirect = true, removeActionForm = true)
  @AcLog(accessType = AccessType.EDIT)
  public String index() {
    String actionId = this.request.getParameter(Constants.ACTION_ID);
    Action action = this.config.getActions().get(actionId);

    FileInputStream[] xsls = null;
    try {

      // 画面入力値
      Map<String, String> map = new HashMap<String, String>();

      for (String key : this.saveForm.paramMap.keySet()) {
        String[] values = this.saveForm.paramMap.get(key);
        if (values.length > 0) {
          map.put(key, values[0]);
        }
      }

      // 第二引数：画面入力値、第三引数：変更フィールドのみ
      this.dbService.persist(action, map, this.saveForm.changeDatas.getPersistMap());

      if (this.saveForm.imgFile != null) {
        byte[] fileByteArray = IOUtils.toByteArray(this.saveForm.imgFile.getInputStream());
        if (fileByteArray.length > 0) {
          // FIXME 画像保存のためのキー項目を選定する方法
          // this.zifileService.persist(kikaku.kika101, kikaku.kika002,
          // fileByteArray);
        }
      }

      if (StringUtils.isNotBlank(this.saveForm.changeDatas.getChangeContent())) {
        // いずれかの情報が更新されていたら、更新履歴を出力する
        ChangeLog changeLog = new ChangeLog();
        changeLog.aplCd = action.getAplCd();
        changeLog.changeTime = new Date();
        changeLog.aplSeq = new BigInteger(map.get(action.getPrimaryActionQuery().getQueryParams()
            .get(0).getId()));
        changeLog.userId = this.request.getRemoteUser();
        changeLog.updatedContent = this.saveForm.changeDatas.getChangeContent();
        this.changeLogService.insert(changeLog);
      }

      String forward = action.getForward();
      // 設定ファイルに指定されたforwardにパラメータが指定されていたら、そのパラメータを尊重する。
      // ここでそのパラメータキーを取得する
      Set<String> specifiedParam = this.getSpecifiedParam(forward);

      StringBuilder prmStr = new StringBuilder();

      // 画面入力値をリクエストパラメータの文字列に変換
      for (String key : map.keySet()) {
        if (!specifiedParam.contains(key)) {
          if (StringUtils.isNotBlank(map.get(key))) {
            if (specifiedParam.size() == 0 && prmStr.length() == 0) {
              prmStr.append("?");
            } else {
              prmStr.append("&");
            }

            prmStr.append(key + "=" + URLEncoder.encode(map.get(key), "utf-8"));
          }
        }

      }

      return forward + prmStr.toString();

    } catch (FileNotFoundException e) {
      throw new WasabiRuntimeException(e);
    } catch (IOException e) {
      throw new WasabiRuntimeException(e);
    } finally {
      try {
        if (xsls != null) {
          for (int i = 0; i < xsls.length; i++) {
            xsls[i].close();
          }
        }
      } catch (IOException e) {
        e.printStackTrace();
      }
    }

  }

  private Set<String> getSpecifiedParam(String url) {
    Set<String> specifiedParam = new HashSet<String>();
    if (url.contains("?")) {
      String specifiedParamStr = url.substring(url.indexOf("?") + 1);
      String[] specifiedParamFormula = StringUtils.splitByWholeSeparatorPreserveAllTokens(
          specifiedParamStr, "&amp;");

      for (String s : specifiedParamFormula) {
        String[] specifiedParamUnit = StringUtils.split(s, "=");
        specifiedParam.add(specifiedParamUnit[0]);
      }

    }
    return specifiedParam;
  }

  public static void main(String[] args) throws UnsupportedEncodingException {
    SaveAction action = new SaveAction();
    String url = "../general/disp?formId=plan-mod&amp;actionId=disp";
    Set<String> set = action.getSpecifiedParam(url);
    System.out.println();
    for (String k : set) {
      System.out.println(k);
    }
  }
}
