package jp.co.epson.watch.plaWasabi.action.stx;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.co.epson.watch.plaWasabi.annotation.AcLog;
import jp.co.epson.watch.plaWasabi.annotation.AccessType;
import jp.co.epson.watch.plaWasabi.commons.Constants;
import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;
import jp.co.epson.watch.plaWasabi.dto.formConfig.Action;
import jp.co.epson.watch.plaWasabi.dto.formConfig.FormConfig;
import jp.co.epson.watch.plaWasabi.service.LogicService;
import jp.co.epson.watch.plaWasabi.service.form.FormService;

import org.apache.commons.lang.StringUtils;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.struts.annotation.Execute;

public class GeneralAction {

  @Resource
  private HttpSession session;

  @Resource
  private HttpServletRequest request;

  @Resource
  private HttpServletResponse response;

  @Resource
  private LogicService logicService;

  @Resource
  private FormService formService;

  private FormConfig config;

  private OutputStream os;

  @InitMethod
  public void init() {
    String formId = this.request.getParameter(Constants.FORM_ID);
    if (StringUtils.isNotBlank(formId)) {
      this.config = this.formService.loadFormConfig(formId);
    } else {
      throw new WasabiRuntimeException(Constants.FORM_ID + "がリクエストスコープにありません");
    }

    try {
      this.os = this.response.getOutputStream();
    } catch (IOException e) {
      throw new WasabiRuntimeException(e);
    }

  }

  /**
   * 空のHTMLを表示する
   * 
   * @return
   */
  @Execute(validator = false)
  @AcLog(accessType = AccessType.SEARCH)
  public String renderEmptyHtml() {
    Action action = this.getAction();

    this.logicService.renderEmptyHtml(action, this.os);

    return null;
  }

  /**
   * 表形式の検索結果画面を表示する
   * 
   * @return
   */
  @Execute(validator = false)
  @AcLog(accessType = AccessType.SEARCH)
  public String listSearch() {
    Action action = this.getAction();

    // 検索結果画面を表示する
    this.logicService.search(action, this.getRequestParamater(), this.os);

    return null;

  }

  /**
   * 一品一票形式の編集画面を表示する
   * 
   * @return
   */
  @SuppressWarnings("unchecked")
  @Execute(validator = false)
  @AcLog(accessType = AccessType.SEARCH)
  public String edit() {
    Action action = this.getAction();

    // 検索結果画面を表示する
    Map dataMap = this.logicService.search(action, this.getRequestParamater(), this.os);

    // FIXME 画面オープン時の値をセッションに仮保存
    this.session.setAttribute(Constants.OPEN_MAP_KEY, dataMap);// オープン時の値

    return null;

  }

  /**
   * 一品一票形式の表示画面を表示する
   * 
   * @return
   */
  @Execute(validator = false)
  @AcLog(accessType = AccessType.SEARCH)
  public String disp() {
    Action action = this.getAction();

    // 検索結果画面を表示する
    this.logicService.search(action, this.getRequestParamater(), this.os);

    return null;

  }

  /**
   * Excel出力する
   * 
   * @return
   */
  @Execute(validator = false)
  @AcLog(accessType = AccessType.SEARCH)
  public String excel() {
    Action action = this.getAction();

    this.response.setHeader("Content-Disposition", "attachment;filename=" + action.getAplCd()
        + ".xls");
    this.response.setHeader("Cache-Control", "private");
    this.response.setContentType("application/vnd.ms-excel");

    try {
      this.logicService.excel(action, this.getRequestParamater(), this.os);
      this.os.flush();
      this.os.close();

    } catch (IOException e) {
      throw new WasabiRuntimeException(e);
    }

    return null;

  }

  /**
   * PDFを出力する
   * 
   * @return
   */
  @Execute(validator = false)
  @AcLog(accessType = AccessType.SEARCH)
  public String pdf() {
    Action action = this.getAction();

    this.logicService.pdf(action, this.getRequestParamater(), this.response);

    return null;

  }

  /**
   * 複数のレコードを物理削除する
   * 
   * @return
   */
  @Execute(validator = false)
  @AcLog(accessType = AccessType.EDIT)
  public String physicalDelete() {
    Action action = this.getAction();

    Map<String, String> paramMap = this.getRequestParamater();

    // 削除
    String delIds = paramMap.get("delIds");
    if (StringUtils.isNotBlank(delIds)) {
      String[] delIdArr = StringUtils.split(delIds, "|");
      this.logicService.listDelete(action, delIdArr);
    }

    // 検索結果画面を表示する
    this.logicService.search(action, paramMap, this.os);

    return null;
  }

  /**
   * 設定ファイルからActionを取得する
   * 
   * @return
   */
  private Action getAction() {
    String actionId = this.request.getParameter(Constants.ACTION_ID);
    Action action = this.config.getActions().get(actionId);
    return action;
  }

  private Map<String, String> getRequestParamater() {
    Map<String, String> res = new HashMap<String, String>();

    for (Object key : this.request.getParameterMap().keySet()) {
      String[] value = (String[]) this.request.getParameterMap().get(key);
      res.put((String) key, value[0]);
    }

    return res;
  }

}
