/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.dbms;

import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.exception.NotTypeMatchException;

public class Oracle extends AbstractDataTypeSelectUtil {

    public String convDBTypeToDataType(String typeName) {
        return typeName;
    }

    public DataType selectBestDataType(FieldSetting fieldSetting) {
        String typeName = fieldSetting.getTypeName();
        fieldSetting.setRdbType(fieldSetting.getTypeName());
        DataType dataType = null;
        if (typeName.startsWith("INTEGER")) {
            dataType = getAnyDataType(fieldSetting, "long");
        } else if (typeName.startsWith("BINARY_FLOAT")) {
            dataType = getAnyDataType(fieldSetting, "float");
        } else if (typeName.startsWith("BINARY_DOUBLE")) {
            dataType = getAnyDataType(fieldSetting, "double");

        } else if (typeName.startsWith("RAW")) {
            dataType = getAnyDataType(fieldSetting, "byte[]");
        } else if (typeName.startsWith("BLOB")) {
            dataType = getAnyDataType(fieldSetting, "byte[]");

        } else if (typeName.startsWith("CHAR")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("LONG")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("CLOB")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("VARCHAR2")) {
            dataType = getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("VARCHAR")) {
            dataType = getAnyDataType(fieldSetting, "String");

        } else if (typeName.startsWith("DATE")) {
            dataType = getAnyDataType(fieldSetting, "Date");

        } else if (typeName.startsWith("TIMESTAMP")) {
            dataType = getAnyDataType(fieldSetting, "Timestamp");
        } else if (typeName.startsWith("TIME")) {
            dataType = getAnyDataType(fieldSetting, "Time");
        } else if (typeName.startsWith("DECIMAL")) {
            dataType = getDECIMAL(fieldSetting);
        } else if (typeName.startsWith("NUMERIC")) {
            dataType = getDECIMAL(fieldSetting);
        } else if (typeName.startsWith("NUMBER")) {
            dataType = getDECIMAL(fieldSetting);
        } else {
            throw new NotTypeMatchException(fieldSetting.getTypeName());
        }

        return dataType;
    }

    public String getSuffix() {
        return "oracle";
    }

}
