#include "common.h"
COMDATA::COMDATA(int com_id,IDispatch* addr){
	ZeroMemory(this,sizeof(*this));
	COM_ID=com_id;
	ParentComClass=addr;
}
COMDATA::~COMDATA(){
	int i;
	//MachineCode
	if (MachineCodehDLL) FreeLibrary(MachineCodehDLL);
	//if (MachineCodeDllPath) DeleteFileA(MachineCodeDllPath);
	//DynaCall
	delete [] hDlls;
	delete [] Procs;
	#ifdef AMD
	ReleaseCallBackFunction(ReservedCallBackFunction);
	#endif
	//Structure
	if (!Temporary) for (i=0;i<CompoNum;i++) 
		if (ChildComClass[i]) 
			ChildComClass[i]->Release();
	delete [] ComponentNames;
	delete [] Types;
	delete [] VarNums;
	delete [] Positions;
	//Malloc
	for (i=0;i<BuffNum;i++) {
		if (BuffTemp[i]!=MALLOC_PERMANENT) 
		{
			//delete Buff[i];
			free(Buff[i]);
			Buff[i]=0;
		}
	}
}
void COMDATA::Reset(){
	COMDATA* pData=ParentData;
	COMDATA::~COMDATA();
	COMDATA::COMDATA(this->COM_ID,this->ParentComClass);
	ParentData=pData;//Needs to keep previous value. This information will be used when releasing the ComClass.
}
void COMDATA::Copy(COMDATA* dataOrg){
	int i,vInt,dimPos;
	int* pInt;
	COMDATA* data2;
	COMDATA::Reset();
	switch (this->COM_ID){
	case 0: //DynaCall
		IsUnicode=dataOrg->IsUnicode;
		Address=dataOrg->Address;
		hDllNum=dataOrg->hDllNum;
		if (hDllNum) hDlls=new HINSTANCE[hDllNum];
		for (i=0;i<hDllNum;i++) hDlls[i]=dataOrg->hDlls[i];
		ProcNum=dataOrg->ProcNum;
		if (ProcNum) Procs=new void*[ProcNum];
		for (i=0;i<ProcNum;i++) Procs[i]=dataOrg->Procs[i];
		break;
	case 1: //Structure
		//Copy the number of components and Redim
		CompoNum=dataOrg->CompoNum;
		RedimComponents(CompoNum);
		//Copy information
		for (i=0;i<CompoNum;i++) {
			ComponentNames[i]=CreateUnicode(dataOrg->ComponentNames[i],this,MALLOC_KEEP);
			Types[i]=dataOrg->Types[i];
			VarNums[i]=dataOrg->VarNums[i];
			Positions[i]=dataOrg->Positions[i];
			if (dataOrg->ChildComClass[i]) {
				ChildComClass[i]=NewComClass(this->COM_ID);
				data2=GetDataFromComClass(ChildComClass[i]);
				data2->Copy(GetDataFromComClass(dataOrg->ChildComClass[i]));
				data2->ParentData=this;
			} else ChildComClass[i]=0;
			ChildComClass[i]=dataOrg->ChildComClass[i];//Only the pointer is copied (Object is NOT copied).
		}
		//Copy the structure
		Size=dataOrg->Size;
		Address=Malloc(Size);
		CopyMemory(Address,dataOrg->Address,Size);
		//Copy the Unicodes and ANSI Strings.
		for (i=0;i<CompoNum;i++) {
			if (Types[i]==0x110004 || Types[i]==0x120004) {
				for (dimPos=0;dimPos<VarNums[i];dimPos++) {
					pInt=(int*)((int)dataOrg->Address+dataOrg->Positions[i]+(Types[i]&0xFFFF)*dimPos);
					vInt=*pInt;
					if (Types[i]==0x110004) vInt=(int)CreateAnsiString((LPSTR)vInt,this,MALLOC_KEEP);
					else vInt=(int)CreateUnicode((LPWSTR)vInt,this,MALLOC_KEEP);
					pInt=(int*)((int)Address+Positions[i]+(Types[i]&0xFFFF)*dimPos);
					*pInt=vInt;
				}
			}
		}
		break;
	default:
		break;
	}
}
void* COMDATA::Malloc(unsigned int bSize, int temporary){
	int i;
	for (i=0;i<BuffNum;i++) {
		if (Buff[i]) continue;
		//Buff[i]=new char[bSize+2];
		Buff[i]=(char*)malloc(bSize+2);
		ZeroMemory(Buff[i],bSize+2);
		BuffTemp[i]=temporary;
		BuffLen[i]=bSize+2;
		return (void*)Buff[i];
	}
	//Redim preserve Buff and BuffTemp
	char** Buff2=new char*[BuffNum+1];
	int* BuffTemp2=new int[BuffNum+1];
	int* BuffLen2=new int[BuffNum+1];
	for (i=0;i<BuffNum;i++) {
		Buff2[i]=Buff[i];
		BuffTemp2[i]=BuffTemp[i];
		BuffLen2[i]=BuffLen[i];
	}
	delete Buff;
	delete BuffTemp;
	delete BuffLen;
	Buff=Buff2;
	BuffTemp=BuffTemp2;
	BuffLen=BuffLen2;
	BuffTemp[BuffNum]=temporary;
	BuffLen[BuffNum]=bSize+2;
	//Buff[BuffNum]=new char[bSize+2];
	Buff[BuffNum]=(char*)malloc(bSize+2);
	ZeroMemory(Buff[BuffNum],bSize+2);
	return (void*)Buff[BuffNum++];
}
void COMDATA::MallocFree(void* address){
	if (!address) return;
	for (int i=0;i<BuffNum;i++) {
		if (!Buff[i]) continue;
		if ((UINT)BuffTemp[i]<=(UINT)address && (UINT)address<((UINT)BuffTemp[i]+(UINT)BuffLen[i]))
		{
			//delete Buff[i];
			free(Buff[i]);
			Buff[i]=0;
		}
	}
}
void COMDATA::MallocDelTemp(){
	for (int i=0;i<BuffNum;i++) {
		if (BuffTemp[i]==MALLOC_TEMPORARY)
		{
			//delete Buff[i];
			free(Buff[i]);
			Buff[i]=0;
		}
	}
}
void COMDATA::RedimComponents(int cNum){
	int i;
	delete [] ComponentNames;
	delete [] ChildComClass;
	delete [] Types;
	delete [] VarNums;
	delete [] Positions;
	ComponentNames=new LPWSTR[cNum];
	ChildComClass=new IDispatch*[cNum];
	Types=new int[cNum];
	VarNums=new int[cNum];
	Positions=new int[cNum];
	for (i=0;i<cNum;i++) ChildComClass[i]=0;
}
