#pragma once

#include "ServerToolWrap.h"
#include "Settings.h"
#include "SyncObject.h"
#include "IPathManager.h"
#include "IManagerInterface.h"

/*!
	pX}l[W
*/
class CPathManager : public IManagerInterface, public IPathManager
{
public:
	CPathManager(void);
	virtual ~CPathManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	IManagerInterface
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual void *GetInterface(int ifVersion)
	{
		if(ifVersion != CIPathManagerWrap::GetInterfaceVersion())
			return(NULL);
		return(GetIPathManager());
	};

	//!	I[o[[hʒm
	virtual void NotifyOverload() {};

	///////////////////////////////////////////////////////////////////////////////////////////
	//	IPathManager
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	pX
	virtual int FindPath(LPCSTR path, LPCSTR host, IWorkspaceAccessPtr pathInfo)
	{
		return _FindPath(path, host, CWorkspaceAccess(pathInfo));
	}

	//!	pX擾
	virtual int GetPathCount();

	//!	CfbNXpX擾
	virtual int GetPathByIndex(int index, IWorkspaceAccessPtr pathInfo)
	{
		return _GetPathByIndex(index, CWorkspaceAccess(pathInfo));
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IPathTool擾
	IPathManagerPtr GetIPathManager() { return this; };

	///////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	pX
	virtual int _FindPath(CString path, CString host, CPathInfo pathInfo);

	//!	CfbNXpX擾
	virtual int _GetPathByIndex(int index, CPathInfo pathInfo);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection					m_scopeLock;

	//!	tO
	CInterlockCounter					m_init;

	//!	IServerTool
	CIServerToolWrap							m_serverTool;

	//!	pXݒ
	CPathManagerSetting					m_pathSetting;

	//!	pXXg
	CPathInfoList						m_pathList;

	//!	pXCfbNX
	CStringArray						m_pathIndex;

	//!	pXCfbNX()
	CArray<int>							m_pathIndexLen;

	//!	o[`zXgCfbNX
	CStringArray						m_hostIndex;

	//!	o[`zXg
	int									m_enableVirtualHost;
};
