#pragma once
#include "ThreadSkeleton.h"
#include "Settings.h"
#include "ServerToolWrap.h"
#include "ILogManager.h"

/*!
	OGg
*/
class CLogManagerEntry
{
public:
	CLogManagerEntry() {};
	CLogManagerEntry(CString filePath, CString log)
	{
		m_filePath = filePath;
		m_log = log;
	};

	//!	t@C
	CString	m_filePath;

	//!	O
	CString	m_log;
};

//!	OGgXg
typedef	CList<CLogManagerEntry>	CLogManagerEntryList;


/*!
	ANZXO}l[W

	OLbV@\񋟂
*/
class CLogManager : protected CThreadSkeleton, public IManagerInterface, protected ILogManager
{
public:
	CLogManager(void);
	virtual ~CLogManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	IManagerInterface
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual void *GetInterface(int ifVersion)
	{
		if(ifVersion != CILogManagerWrap::GetInterfaceVersion())
			return(NULL);
		return(GetILogManager());
	};

	//!	I[o[[hʒm
	virtual void NotifyOverload() {};

	///////////////////////////////////////////////////////////////////////////////////////////
	//	ILogManager
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	ANZXOo
	void WriteAccessLog(LPCSTR filePath, LPCSTR log);

	///////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual ILogManagerPtr GetILogManager() { return this; };

	/////////////////////////////////////////////////////////////////////////////////////
	//	Xbh֐
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Xbh
	void ThreadMain();

	//!	Oo
	void FlashLog();

	//!	Ot@C
	void WriteLogs(FILE *log, CString filePath);

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter			m_init;

	//!	T[oc[
	CIServerToolWrap					m_serverTool;

	//!	ݒ
	CLogManagerSetting			m_setting;

	//!	O
	CLogManagerEntryList		m_logList;

	//!	C^[o
	int							m_intervalTime;

	//!	O쐬fBNg
	CString						m_oldDir;
};
