#pragma once
#include "filterbase.h"
#include "FilterBase.h"
#include "FilterFactoryBase.h"
#include "Settings.h"
#include "SyncObject.h"
#include "TextTools.h"

class CKeepAliveFilter :
	public CFilterBase
{
public:
	CKeepAliveFilter(void);
	virtual ~CKeepAliveFilter(void);

	//!	tB^擾
	virtual LPCTSTR GetFilterName();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterFactory
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void _FilterFactoryStart(CIServerToolWrap serverTool);

	//!	~
	virtual void FilterFactoryStop();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	NGXgM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_
	virtual void _FilterRequestHeader(CIConnectionToolWrap filterContext);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|XM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_
	virtual void _FilterResponseHeader(CIConnectionToolWrap filterContext);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	T[oX|XM(O)
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_(OցI)
	virtual void _FilterServerResponse(CIConnectionToolWrap filterContext, CBinaryData &body)
	{
		//!	ʏƓs
		_FilterResponseHeader(filterContext);
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection			m_scopeLock;

	//!	tO
	CInterlockCounter			m_init;

	//!	T[oc[
	CIServerToolWrap				m_serverTool;

	//!	ݒ
	CKeepAliveFilterSetting		m_setting;

	//!	KeepAliveL
	int							m_enableKeepAlive;

	//!	KeepAlive
	int							m_keepAliveTime;

	//!	KeepAlive
	int							m_keepAliveCount;
};



class CKeepAliveFilterFactory :
	public CFilterFactoryBase
{
public:
	CKeepAliveFilterFactory(void) {};
	virtual ~CKeepAliveFilterFactory(void) {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterFactory
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	IFilterPtr FilterFactoryGetFilter()
	{
		return &m_filter;
	}

	//!	
	virtual void _FilterFactoryStart(CIServerToolWrap serverTool)
	{
		m_filter._FilterFactoryStart(serverTool);
	}

	//!	~
	virtual void _FilterFactoryStop()
	{
		m_filter.FilterFactoryStop();
	}

	//!	폜
	virtual void _FilterFactoryDelete()
	{
		delete this;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^
	CKeepAliveFilter			m_filter;
};
