#include "StdAfx.h"
#include "DirectoryIndexResponse.h"
#include "HtmlLoader.h"
#include "PathManager.h"
#include "Dir.h"
#include "MimeTypeManager.h"
#include "UrlUtility.h"
#include "ServerTextManager.h"
#include "TextFormatter.h"


#define	MAX_LINE	2048

//!	W[
static TCHAR _MODULE_NAME[] = _T("DirectoryIndexResponse");

CDirectoryIndexResponse::CDirectoryIndexResponse(void)
{
}

CDirectoryIndexResponse::~CDirectoryIndexResponse(void)
{
}

/*!
	X|X擾
*/
LPCTSTR CDirectoryIndexResponse::GetResponseName()
{
	return _MODULE_NAME;
};

//////////////////////////////////////////////////////////////////////////////////////////////
//	X|X
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	X|X
*/
void CDirectoryIndexResponse::_ResponseBuildResponse(CIConnectionToolWrap responseContext)
{
	CContext			context = responseContext.GetContxet();
	CContextTargetInfo	targetInfo = context.GetTargetInfo();

	//	fBNg\͋Ă̂H
	if(!targetInfo.GetPathInfo().GetOption().GetEnableDirectoryIndex())
		throw CServerResponseException(403, _T("CfbNX\͋Ă܂"));

	//	͖Ƃ
	if(!targetInfo.GetTargetIsExist())
		throw CServerResponseException(404, _T("w肳ꂽfBNg݂͑܂"));

	//	\bhGET?
	if(responseContext.GetContxet().GetRequestInfo().GetMethod() != "GET")
		throw CServerResponseException(405, _T("ΉĂȂ\bhł"));

	//	t@CXg擾
	CBinaryData	fileList;
	BuildFileList(responseContext, fileList);

	//	HTMLt@C擾
	CString	html = LoadHtml(responseContext);

	//	
	CTextFormatter	formatter;

	//	fBNgXg
	formatter.AddKey("FileList", fileList.GetCString());

	//	T[o
	formatter.AddKeyFromWorkspace(CIServerToolWrap(responseContext.GetIServerTool()).GetIServerInfoManager().GetServerInfo());

	//	ReLXg{
	formatter.AddKeyFromWorkspace(context);

	//	NCAg
	formatter.AddKeyFromWorkspace(context.GetClientInfo());

	//	NGXg
	formatter.AddKeyFromWorkspace(context.GetRequestInfo());
	formatter.AddKeyFromWorkspace(context.GetRequestInfo().GetRequestOption(), "Req:");

	//	X|X
	formatter.AddKeyFromWorkspace(context.GetResponseInfo());
	formatter.AddKeyFromWorkspace(context.GetResponseInfo().GetResponseOption(), "Res:");

	//	^[Qbg
	formatter.AddKeyFromWorkspace(context.GetTargetInfo());

	//	s
	m_responseBody = formatter.GetFormattedString(html);
}


/*!
	X|Xwb_擾
*/
void CDirectoryIndexResponse::_ResponseGetResponse(CIConnectionToolWrap responseContext)
{
	CContextResponseInfo responseInfo = responseContext.GetContxet().GetResponseInfo();

	//	R[hݒ
	responseInfo.SetResponseCode(200);

	//	X|XTCYݒ
	responseInfo.GetResponseOption().SetContentLength(m_responseBody.GetLength());

	//	MimeType
	responseInfo.GetResponseOption().SetContentType("text/html");
}

/*!
	X|X{fB擾
*/
int CDirectoryIndexResponse::_ResponseGetResponseBody(CIConnectionToolWrap responseContext, CBinaryData &body, int blockSize)
{
	if(m_responseBody.IsEmpty())
		return(0);

	//	f[^Ԃ
	body.Empty();
	body.AppendString(m_responseBody);
	m_responseBody.Empty();
	return(body.GetSize());
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	t@CXg̎擾
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	t@CXg
*/
void CDirectoryIndexResponse::BuildFileList(CIConnectionToolWrap responseContext, CBinaryData &fileListHtml)
{
	CString			iconPath;
	int				sortMode = -1;
	CFileItemArray	linkList, dirList, fileList;

	//	MimeType}l[W擾
	CIMimeTypeManagerWrap	mimeTypeMgr = responseContext.GetIServerTool().GetIMimeTypeManager();
	CContext				context = responseContext.GetContxet();
	CContextRequestInfo		requestInfo = context.GetRequestInfo();
	CContextTargetInfo		targetInfo = context.GetTargetInfo();

	//	UP
	if(requestInfo.GetObject() != "/")
		AddListLine(fileListHtml, "Parent Directory", "../", mimeTypeMgr.GetIconPathByName(".."));

	//	t@CEfBNgXg擾
	GetDirectoryList(dirList, fileList, targetInfo.GetTarget(), targetInfo.GetPathInfo().GetOption().GetShowHiddenFile(), sortMode);

	//	NXg擾
	GetLinkList(responseContext, linkList, sortMode);

	//	fBNgXgo
	iconPath = mimeTypeMgr.GetIconPathByName("^^DIRECTORY^^");
	for(int i=0;i<dirList.GetSize();i++)
		AddListLine(fileListHtml, dirList[i].m_name, dirList[i].m_name, iconPath, -1, dirList[i].m_lastUpdate);

	//	NXgo
	iconPath = mimeTypeMgr.GetIconPathByName("^^LINK^^");
	for(int i=0;i<linkList.GetSize();i++)
		AddListLine(fileListHtml, linkList[i].m_name, linkList[i].m_name, iconPath);

	//	t@CXgo
	for(int i=0;i<fileList.GetSize();i++)
		AddListLine(fileListHtml, fileList[i].m_name, fileList[i].m_name, mimeTypeMgr.GetIconPathByName(fileList[i].m_name), 
					fileList[i].m_size, fileList[i].m_lastUpdate);
}


/*!
	sǉ
*/
void CDirectoryIndexResponse::AddListLine(CBinaryData &fileListHtml, CString name, CString path, CString iconPath, __int64 size, CTime updateTime)
{
	TCHAR		stringBuf[MAX_LINE];

	if(size == -1)
	{
		if(updateTime == 0)
		{
			_snprintf_s(stringBuf, MAX_LINE, MAX_LINE,
				"<IMG SRC=\"%s\"> <A HREF=\"%s\">%-70s -                        -  \n",
				iconPath, CUrlUtility::EncodeUrl(path), name + "</A>");
		}
		else
		{
			_snprintf_s(stringBuf, MAX_LINE, MAX_LINE,
				"<IMG SRC=\"%s\"> <A HREF=\"%s\">%-70s%s       -  \n",
				iconPath, CUrlUtility::EncodeUrl(path), name + "</A>", updateTime.Format("%Y/%m/%d %H:%M:%S"));
		}
	}
	else if(size < 10240)
	{
		_snprintf_s(stringBuf, MAX_LINE, MAX_LINE,
				"<IMG SRC=\"%s\"> <A HREF=\"%s\">%-70s%s      %I64d  \n",
				iconPath, CUrlUtility::EncodeUrl(path), name + "</A>",
				updateTime.Format("%Y/%m/%d %H:%M:%S"), size);
	}
	else if(size < 1048576 * 10)
	{
		_snprintf_s(stringBuf, MAX_LINE, MAX_LINE,
				"<IMG SRC=\"%s\"> <A HREF=\"%s\">%-70s%s      %I64dK  \n",
				iconPath,CUrlUtility::EncodeUrl(path), name + "</A>",
				updateTime.Format("%Y/%m/%d %H:%M:%S"), size/1024);
	}
	else
	{
		_snprintf_s(stringBuf, MAX_LINE, MAX_LINE,
				"<IMG SRC=\"%s\"> <A HREF=\"%s\">%-70s%s      %I64dM  \n",
				iconPath,CUrlUtility::EncodeUrl(path), name + "</A>",
				updateTime.Format("%Y/%m/%d %H:%M:%S"), size/1048576);
	}

	fileListHtml.Append(stringBuf, strlen(stringBuf));
}


/*!
	HTML[h
*/
CString CDirectoryIndexResponse::LoadHtml(CIConnectionToolWrap responseContext)
{
	CString	html = CHtmlLoader::LoadFromFile(responseContext.GetContxet().GetTargetInfo().GetTarget() + "DirectoryList.html");
	if(html.IsEmpty())
		html = responseContext.GetIServerTool().GetIServerTextManager().LoadServerHtmlFile("DirectoryList.html");
	if(html.IsEmpty())
		html = responseContext.GetIServerTool().GetIServerTextManager().LoadServerHtmlResource(HTML_RESOURCE_DIRECTORY_LIST);

	return(html);
}



/*!
	NXg̎擾
*/
void CDirectoryIndexResponse::GetLinkList(CIConnectionToolWrap responseContext, CFileItemArray & list, int sortMode)
{
	CWorkspace			pathRoot;
	CPathInfo	pathInfo = pathRoot.GetAccess("Path");

	list.RemoveAll();

	//	^[QbgpX
	CString	targetServerPath = CPathTools::AddBackSlash(responseContext.GetContxet().GetRequestInfo().GetObject());
	int		targetServerPathLen = targetServerPath.GetLength();

	//	zXg
	CString	host = responseContext.GetContxet().GetRequestInfo().GetRequestOption().GetHost();

	//	Xg擾
	CIPathManagerWrap pathManager = responseContext.GetIServerTool().GetIPathManager();

	//	Xgݒ
	for(int i=0;i<pathManager.GetPathCount();i++)
	{
		//	pXݒ擾
		pathManager.GetPathByIndex(i, pathInfo);

		//	T[opX擾(Ō/폜)
		CString	serverPath = CPathTools::RemoveSlash(pathInfo.GetServerPath());

		//	H
		if(targetServerPathLen >= serverPath.GetLength())
			continue;

		//	؂o
		int index = serverPath.ReverseFind('/');
		if(index == -1)
			continue;

		//	H
		if(targetServerPath.CompareNoCase(serverPath.Mid(0,index + 1))==0)
			list.Add(CFileItem(CPathTools::AddSlash(serverPath.Mid(index + 1)), 0, 0, sortMode));
	}

	//	\[gL
	if(sortMode != -1)
		list.Sort();
}


/*!
	fBNgXg̎擾
*/
void CDirectoryIndexResponse::GetDirectoryList(CFileItemArray &directoryList, CFileItemArray &fileList, CString targetDir, int showHiddenFile, int sortMode)
{
	directoryList.RemoveAll();
	fileList.RemoveAll();

	//	
	int				done=1;
	CFileFind		find;
	if(find.FindFile(targetDir + "*.*"))
	{
		while(done)
		{
			done=find.FindNextFile();

			if(find.IsDots())
				continue;

			if(find.IsHidden() && showHiddenFile == 0)
				continue;

			//	XV擾
			CTime	lastUpdate;
			find.GetLastWriteTime(lastUpdate);

			//	fBNg?
			if(find.IsDirectory())
				directoryList.Add(CFileItem(CPathTools::AddSlash(find.GetFileName()), lastUpdate, 0, sortMode));
			else
				fileList.Add(CFileItem(find.GetFileName(), lastUpdate, find.GetLength(), sortMode));
		}
	}
	find.Close();

	//	\[gL
	if(sortMode != -1)
	{
		directoryList.Sort();
		fileList.Sort();
	}
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	擾
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	̃ACeH
*/
int CDirectoryIndexResponseFactory::_ResponseFactoryIsYourRequest(CContext context)
{
	//	^[Qbg擾
	CContextTargetInfo targetInfo = context.GetTargetInfo();

	//	fBNg
	if(targetInfo.GetTargetIsDirectory() && targetInfo.GetTargetIsExist())
		return(TRUE);
	return(FALSE);
}

