#include "StdAfx.h"
#include ".\bufferdsocket.h"
#include "threadskeleton.h"
#include <ws2tcpip.h>

#define	BUF_SIZE			(32*1024)

CBufferdSocket::CBufferdSocket(void)
{
	//	Cxg
	m_closeEvent.Create(TRUE,FALSE);
	m_exBreakEvent = NULL;

	//	̊m
	m_recvBuf.InitBuf(BUF_SIZE);
	m_sendBuf.InitBuf(BUF_SIZE);
}


CBufferdSocket::~CBufferdSocket(void)
{
	Close();
	m_recvBuf.Close();
	m_sendBuf.Close();
}

//////////////////////////////////////////////////////////////////////////////////
//	Ȃ
//////////////////////////////////////////////////////////////////////////////////
/*!
	gpJn
*/
int CBufferdSocket::AttachSocket(SOCKET sock)
{
	//	I
	Close();

	//	\PbgubLO[h
	if(::WSAEventSelect(sock, m_closeEvent, FD_CLOSE))
	{
		CloseError(CBS_ERROR_OTHER,"AttachSocket");
		return(-1);
	}

	//	obt@NA
	m_recvBuf.Clear();
	m_sendBuf.Clear();

	//	ϐݒ
	m_socket.AttachSocket(sock);
	ClearError();

	//	CxgNA
	::ResetEvent(m_closeEvent);

	return(0);
}


/*!
	
*/
void CBufferdSocket::Close()
{
	if(m_socket != INVALID_SOCKET)
	{
		//	\Pbgnh֘At
		::WSAEventSelect(m_socket, m_closeEvent, 0);

		//	
		m_socket.Close();
	}


	//	ǂݏo\̂ŁAobt@̓IuWFNg폜܂ŊJȂ
}

//////////////////////////////////////////////////////////////////////////////////
//	fC^[tF[X
//////////////////////////////////////////////////////////////////////////////////
/*!
	fCxgݒ
*/
void CBufferdSocket::SetExBreakEvent(HANDLE exBreakEvent)
{
	m_exBreakEvent = exBreakEvent;
	m_socket.SetBreakEvent(m_exBreakEvent);
}


//////////////////////////////////////////////////////////////////////////////////
//	M(񓯊)
//////////////////////////////////////////////////////////////////////////////////
/*!
	M
*/
int CBufferdSocket::WriteBuf(char *data,int len)
{
	//	G[NA
	ClearError();

	return(m_sendBuf.WriteBuf(data,len));
}


/*!
	M
*/
int CBufferdSocket::ReadBuf(char *data,int len)
{
	//	G[NA
	ClearError();

	return(m_recvBuf.ReadBuf(data,len));
}


/*!
	M(obt@Ȃ)
*/
int CBufferdSocket::PeekBuf(char *data,int len)
{
	//	G[NA
	ClearError();

	return(m_recvBuf.PeekBuf(data,len));
}



/*!
	\PbgĂ邩`FbN

	߂l: TRUE:Ă
*/
int CBufferdSocket::CheckCloseEvent()
{
	//	G[NA
	ClearError();

	//	\PbǵH
	if(m_socket == INVALID_SOCKET)
		return(TRUE);

	//	Cxg҂
	switch(CThreadSkeleton::WaitForSomeObjects(0, m_closeEvent, m_exBreakEvent))
	{
	case 0:
		return(FALSE);

	case 1:
		CloseError(CBS_ERROR_CLOSE,"WaitNextEvent");
		break;

	case 2:
		CloseError(CBS_ERROR_BREAK,"WaitNextEvent - f");
		break;

	default:
		CloseError(CBS_ERROR_OTHER,"WaitNextEvent - WaitForMultipleObjects");
		break;
	}
	return(TRUE);
}

//////////////////////////////////////////////////////////////////////////////////
//	ʐMXe[^X
//////////////////////////////////////////////////////////////////////////////////
/*!
	ؒfĂ邩擾
*/
int CBufferdSocket::IsDisconnect()
{
	//	Cxg҂Ă݂
	return CheckCloseEvent();
}

/*!
	obt@TCY擾
*/
int CBufferdSocket::GetSendRecvBufSize()
{
	return(BUF_SIZE);
}

//////////////////////////////////////////////////////////////////////////////////
//	ڑ
//////////////////////////////////////////////////////////////////////////////////
/*!
	̃AhX擾
*/
CIPAddress CBufferdSocket::GetAddres()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getsockname(m_socket,(SOCKADDR*)&addr,&nSockAddrLen);
	return(addr.sin_addr);
}

/*!
	̃AhX擾
*/
CIPAddress CBufferdSocket::GetPeerAddres()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getpeername(m_socket,(SOCKADDR*)&addr,&nSockAddrLen);
	return(addr.sin_addr);
}

/*!
	̃|[g擾	
*/
int CBufferdSocket::GetPort()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getsockname(m_socket,(SOCKADDR*)&addr,&nSockAddrLen);
	return(ntohs(addr.sin_port));
}

/*!
	̃|[g擾
*/
int CBufferdSocket::GetPeerPort()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getpeername(m_socket,(SOCKADDR*)&addr,&nSockAddrLen);
	return(ntohs(addr.sin_port));
}


//////////////////////////////////////////////////////////////////////////////////
//	ʐM
//////////////////////////////////////////////////////////////////////////////////
/*!
	M

	\return	-1:G[A0:MA>0:cf[^
*/
int CBufferdSocket::BlockingSend(int timeOut)
{
	//	f[^?
	if(m_sendBuf.GetInBuf() == 0)
		return(0);

	//	Mpobt@擾
	int		bufLen;
	char	*sendBuf = m_sendBuf.GetReadBuffer(&bufLen);

	//	M
	int sended = m_socket.BlockingSend(sendBuf, bufLen, timeOut);
	if(sended <= 0)
	{
		switch(m_socket.GetLastError())
		{
		case COverlappedSocket::OVRS_ERROR_TIMEOUT:
			CloseError(CBS_ERROR_TIMEOUT,"BlockingSend");
			break;

		case COverlappedSocket::OVRS_ERROR_CLOSE:
			CloseError(CBS_ERROR_CLOSE,"BlockingSend");
			break;

		case COverlappedSocket::OVRS_ERROR_BREAK:
			CloseError(CBS_ERROR_BREAK,"BlockingSend");
			break;

		case COverlappedSocket::OVRS_ERROR_OTHER:
		default:
			CloseError(CBS_ERROR_OTHER,"BlockingSend");
			break;
		}
		return(-1);
	}

	//	Mf[^ʂݒ
	m_sendBuf.SetReadedLen(sended);
	return(m_sendBuf.GetInBuf());
}


/*!
	M

	\return	-1:G[A0:MȂA>0:Mf[^
*/
int CBufferdSocket::BlockingRecv(int timeOut)
{
	//	obt@邩H
	if(m_recvBuf.GetFreeBuf() == 0)
		return(m_recvBuf.GetInBuf());	//	f[^Mς݂ȂI

	//	Mpobt@擾
	int		bufLen;
	char	*recvBuf = m_recvBuf.GetWriteBuffer(&bufLen);

	//	M
	int recved = m_socket.BlockingRecv(recvBuf, bufLen, timeOut);
	if(recved <= 0)
	{
		switch(m_socket.GetLastError())
		{
		case COverlappedSocket::OVRS_ERROR_TIMEOUT:
			CloseError(CBS_ERROR_TIMEOUT,"BlockingRecv");
			break;

		case COverlappedSocket::OVRS_ERROR_CLOSE:
			CloseError(CBS_ERROR_CLOSE,"BlockingSend");
			break;

		case COverlappedSocket::OVRS_ERROR_BREAK:
			CloseError(CBS_ERROR_BREAK,"BlockingRecv");
			break;

		case COverlappedSocket::OVRS_ERROR_OTHER:
		default:
			CloseError(CBS_ERROR_OTHER,"BlockingRecv");
			break;
		}
		return(-1);
	}

	//	Mf[^ʂݒ
	m_recvBuf.SetWritedLen(recved);
	return(m_recvBuf.GetInBuf());
}


//////////////////////////////////////////////////////////////////////////////////
//	G[
//////////////////////////////////////////////////////////////////////////////////
/*!
	G[ŕ
*/
void CBufferdSocket::CloseError(int code, CString debugInfo)
{
	TRACE("SocketError : %d [%s] (SocketError : %d)\n", code, debugInfo, WSAGetLastError());
	m_lastError = code;

	//	\Pbg
	if(m_socket != INVALID_SOCKET)
		Close();
}

/*!
	G[𕶎Ŏ擾
*/
CString CBufferdSocket::GetLastErrorString()
{
	return(GetErrorString(GetLastError()));
}

/*!
	G[R[h當擾
*/
CString CBufferdSocket::GetErrorString(int errorCode)
{
	switch(errorCode)
	{
	case CBS_ERROR_TIMEOUT:
		return(_T("^CAEg܂"));

	case CBS_ERROR_CLOSE:
		return(_T("ڑI܂"));

	case CBS_ERROR_BREAK:
		return(_T("f܂"));

	case CBS_ERROR_OTHER:
		return(_T("lbg[NG[ł"));


	case CBS_NO_ERROR:
	default:
		return(_T("sȃG[ł"));
	}
}
