#pragma once
#include "StackAlloc.h"


template<int INTERNAL_BUF_SIZE = 256>
class CWorkspaceString
{
public:
	CWorkspaceString(void)
	{
		InternalInit();
	}

	CWorkspaceString(const CWorkspaceString &other)
	{
		InternalInit();

		*this = other;
	}

	CWorkspaceString(const LPU8STR other)
	{
		InternalInit();

		*this = other;
	}

	virtual ~CWorkspaceString(void)
	{
		InternalInit();
	}

	/*!
		
	*/
	void InternalInit()
	{
		//	󕶎
		ReSize(0);
		GetString()[0] = 0;
		m_strLen = 0;
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	LPCU8STR
	operator LPCU8STR() const
	{
		return const_cast<CWorkspaceString *>(this)->GetString();
	}

	//!	LPU8STR
	operator LPU8STR()
	{
		return GetString();
	}

	//!	TCY擾
	int GetLength() const
	{
		return m_strLen;
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CWorkspaceString
	void operator=(const CWorkspaceString &_other)
	{
		CWorkspaceString &other = const_cast<CWorkspaceString&>(_other);
		Copy(other, other.GetLength());
	}

	//!	LPCU8STR
	void operator=(LPCU8STR other)
	{
		Copy(other, strlen((LPCSTR)other));
	}


protected:
	//////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	//////////////////////////////////////////////////////////////////////////////////////////
	/*!
		m
	*/
	void ReSize(int size)
	{
		size ++;

		m_stackBuf.Alloc(size);
	}


	/*!
		Rs[
	*/
	void Copy(LPCU8STR src, int len)
	{
		ReSize(len);

		//	Rs[
		memcpy(GetString(), src, len + 1);
		m_strLen = len;
	}

	//!	̎擾
	LPU8STR GetString()
	{
		return (LPU8STR)m_stackBuf.GetPtr();
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	̒
	int									m_strLen;

	//!	mۃ
	CStackAlloc<INTERNAL_BUF_SIZE>		m_stackBuf;
};


//!	WTCY
typedef CWorkspaceString<256> CWorkspaceString255;
