#include "StdAfx.h"
#include "WorkspaceListAccess.h"


/*****************************************************************************************************/
//	񃊃XgNX
/*****************************************************************************************************/
//////////////////////////////////////////////////////////////////////////////
//	CWorkspaceStringListAccess
//////////////////////////////////////////////////////////////////////////////
CWorkspaceStringListAccess::CWorkspaceStringListAccess(CUTF8String listName)
{
	m_listName = listName;
}

CWorkspaceStringListAccess::~CWorkspaceStringListAccess(void)
{
}

CWorkspaceStringListAccess::CWorkspaceStringListAccess(CWorkspaceAccess &other, CUTF8String listName)
{
	m_listName = listName;
	CWorkspaceAccess::operator=(other);
}

//////////////////////////////////////////////////////////////////////////////
//	擾
//////////////////////////////////////////////////////////////////////////////
/*!
	̎擾
*/
int CWorkspaceStringListAccess::GetItemCount()
{
	return(GetKeyCount());
}

/*!
	ACe̎擾
*/
CUTF8String CWorkspaceStringListAccess::GetItem(int index)
{
	//	SẴTum[h擾
	CUTF8StringArray	list;
	GetAllKey(list);

	//	Ώۂ擾
	return(GetKeyStr(list[index], _U8("")));
}

/*!
	ACe̐ݒ
*/
void CWorkspaceStringListAccess::SetItem(int index, CUTF8String str)
{
	//	SẴTum[h擾
	CUTF8StringArray	list;
	GetAllKey(list);

	//	Ώۂ㏑
	SetKeyStr(list[index], str);
}

/*!
	ACeǉ
*/
void CWorkspaceStringListAccess::AddNewItem(CUTF8String str, int checkExist, int noCase)
{
	//	dȂĂH
	if(checkExist)
		if(FindIndex(str, noCase) != -1)
			return;

	int itemNo = 0;
	CUTF8String	name;

	//	dȂĂȂOT
	CUTF8StringArray	list;
	GetAllKey(list);
	while(1)
	{
		//	Ȃ
		int loopFlag = 0;
		name.Format(_U8("%s_%04d"), m_listName, itemNo);
		for(int i=0; i<list.GetCount(); i++)
		{
			if(name.CompareNoCase(list[i]) == 0)
				loopFlag = 1;
		}

		//	Ȃ
		if(loopFlag == 0)
			break;

		//	
		itemNo ++;
	}
	
	SetKeyStr(name, str);
}

/*!
	ACe̍폜
*/
void CWorkspaceStringListAccess::DeleteItem(int index)
{
	//	SẴTum[h擾
	CUTF8StringArray	list;
	GetAllKey(list);

	//	Ώۂ폜
	DeleteKey(list[index]);
}

/*!
	܂Ƃ߂Ēǉ
*/
void CWorkspaceStringListAccess::AddList(CUTF8StringArray &list, int checkExist, int noCase)
{
	for(int i=0;i<list.GetCount();i++)
		AddNewItem(list[i], checkExist, noCase);
}

/*!
	܂Ƃ߂Ď擾
*/
void CWorkspaceStringListAccess::GetList(CUTF8StringArray &list)
{
	GetAllData(list);
}

/*!
	
*/
int CWorkspaceStringListAccess::FindIndex(CUTF8String str, int noCase)
{
	//	ׂĎ擾
	CUTF8StringArray	list;
	GetList(list);

	//	
	for(int i=0;i<list.GetCount();i++)
	{
		if(noCase)
		{
			if(str.CompareNoCase(list[i]) == 0)
				return(i);
		}
		else
		{
			if(str == list[i])
				return(i);
		}
	}

	return(-1);
}



/*****************************************************************************************************/
//	XgNX
/*****************************************************************************************************/
//////////////////////////////////////////////////////////////////////////////
//	CWorkspaceListAccess
//////////////////////////////////////////////////////////////////////////////
CWorkspaceListAccess::CWorkspaceListAccess(CUTF8String listName)
{
	m_listName = listName;
}

CWorkspaceListAccess::~CWorkspaceListAccess(void)
{
}

CWorkspaceListAccess::CWorkspaceListAccess(CWorkspaceAccess &other, CUTF8String listName)
{
	m_listName = listName;
	CWorkspaceAccess::operator=(other);
}

//////////////////////////////////////////////////////////////////////////////
//	擾
//////////////////////////////////////////////////////////////////////////////
/*!
	̎擾
*/
int CWorkspaceListAccess::GetItemCount()
{
	return(GetSubNodeCount());
}


/*!
	ACe̎擾
*/
CWorkspaceAccess CWorkspaceListAccess::GetItem(int index)
{
	//	SẴTum[h擾
	CUTF8StringArray	list;
	GetAllSubNode(list);

	//	S`FbN
	ASSERT(index >= 0 && index < list.GetCount());

	//	Ώۂ擾
	return(GetAccess(list[index]));
}


/*!
	ACeǉ
*/
CWorkspaceAccess CWorkspaceListAccess::GetNewItem()
{
	int itemNo = 0;
	CUTF8String	name;

	//	dȂĂȂOT
	CUTF8StringArray	list;
	GetAllSubNode(list);
	while(1)
	{
		//	Ȃ
		int loopFlag = 0;
		name.Format(_U8("%s_%04d"), m_listName, itemNo);
		for(int i=0; i<list.GetCount(); i++)
		{
			if(name.CompareNoCase(list[i]) == 0)
				loopFlag = 1;
		}

		//	Ȃ
		if(loopFlag == 0)
			break;

		//	
		itemNo ++;
	}
	
	return(GetAccess(name));
}


/*!
	ACe̍폜
*/
void CWorkspaceListAccess::DeleteItem(CWorkspaceAccess item)
{
	DeleteNode(item.GetNodeName());
}


/*!
	ACe̍폜
*/
void CWorkspaceListAccess::DeleteItem(int index)
{
	DeleteNode(GetItem(index).GetNodeName());
}

//////////////////////////////////////////////////////////////////////////////
//	\[g
//////////////////////////////////////////////////////////////////////////////
/*!
	\[g
*/
void CWorkspaceListAccess::Sort(IWorkspaceListAccessSortBase &sortBase, int reverse)
{
	//	e|
	CWorkspaceAccess	keyitem = GetNewItem();

	//	\[g
	int Max = (int)GetItemCount();
	for(int i=1;i<Max;i++)
	{
		keyitem.Copy(GetItem(i));

		int	j;
		for(j=i-1;j>=0;j--)
		{
			//	r
			if(!reverse)
			{
				if(sortBase.IsBefore(GetItem(j), keyitem))
					GetItem(j+1).Copy(GetItem(j));
				else
					break;
			}
			else
			{
				if(!sortBase.IsBefore(GetItem(j), keyitem))
					GetItem(j+1).Copy(GetItem(j));
				else
					break;
			}
		}

		GetItem(j+1).Copy(keyitem);
	}

	//	e|폜
	DeleteItem(keyitem);
}


/*!
	\[g(L[e)
*/
void CWorkspaceListAccess::Sort(CUTF8String key1, CUTF8String key2, CUTF8String key3)
{
	//	\[gpNX
	CWorkspaceListAccessSimpleSort	sort;

	//	\[gǉ
	sort.AddKeyName(key1);
	if(!key2.IsEmpty())
		sort.AddKeyName(key2);
	if(!key3.IsEmpty())
		sort.AddKeyName(key3);

	//	\[g
	Sort(sort);
}

/*****************************************************************************************************/
//	\[gpNX
/*****************************************************************************************************/
//////////////////////////////////////////////////////////////////////////////
//	CWorkspaceListAccessSimpleSort
//////////////////////////////////////////////////////////////////////////////
/*!
	r
*/
int CWorkspaceListAccessSimpleSort::IsBefore(CWorkspaceAccess from, CWorkspaceAccess to)
{
	ASSERT(m_keyNameArray.GetCount() > 0);

	for(int i=0;i<m_keyNameArray.GetCount();i++)
	{
		if(from.GetKeyStr(m_keyNameArray[i], _U8("")) != to.GetKeyStr(m_keyNameArray[i], _U8("")))
			return(from.GetKeyStr(m_keyNameArray[i], _U8("")) > to.GetKeyStr(m_keyNameArray[i], _U8("")));
	}

	return(TRUE);
}

