/*!
	UrlTools.cpp

	URL֌W̏
*/

#include "stdafx.h"
#include "UrlTools.h"
#include "UTF8StringTool.h"

//////////////////////////////////////////////////////////////////////
//	GR[hAfR[h
//////////////////////////////////////////////////////////////////////
/*!
	URLfR[hs
*/
void CUrlTools::UrlDecode(CUTF8String str, CBinaryData &decoded)
{
	//	ۂ
	decoded.SetNoFreeEmpty(TRUE);
	decoded.ReSize(0);

	//	WJ
	LPCU8STR	src = str.GetString();
	while(src[0] != 0)
	{
		//	"%"?
		if(src[0] =='%' && src[1] != 0 && src[2] != 0)
		{
			//	ϊ
			char hex[] = { src[1], src[2], 0 };
			decoded.AppendByte((char)strtol(hex, NULL, 16));

			src+=2;
		}
		else if(src[0] == '+')
		{
			decoded.AppendByte(' ');
		}
		else
		{
			decoded.AppendByte(src[0]);
		}
		src++;
	}
}

/*!
	URLGR[hs
*/
CUTF8String CUrlTools::UrlEncode(CUTF8String str)
{
	CUTF8String		ret;
	LPCU8STR		src = str.GetString();

	//	WJ
	while(*src != 0)
	{
		if(*src <= 0x20 || *src == '%' || *src == '#' ||  *src == '+' || *src >= 0x80)
		{
			//	댯ȕ
			char	line[10];
			sprintf_s(line, 10, "%%%02x", *src);
			ret += (LPCU8STR)line;
		}
		else
		{
			ret += *src;
		}
		src++;
	}
	
	return(ret);
}

/*!
	UrlUTF8փRo[g݂

	UrlfR[h͍sȂ̂ŁA\߃fR[hĂKv
	ňUUTF16֕ϊAR[h̐؂Ă
	sƁA-1Ԃ
*/
int CUrlTools::UrlConvertToUTF8(CBinaryData decodedUrl, CUTF8String &utf8)
{
	int		len = decodedUrl.GetSize();
	decodedUrl.AppendByte(0);	//	ɂ
	LPCSTR	unknown = decodedUrl.GetPtr();

	//	0mF
	LPCSTR ptr = unknown;
	for(int i=0;i<len;i++)
		if(ptr[i] == 0)
			return(-1);		//	ϊs\

	//	ASCII/UTF8?
	if(CUTF8StringTool::CheckAllAscii(decodedUrl.GetPtr(), len) || CUTF8StringTool::CheckIsUTF8(decodedUrl.GetPtr(), len))
	{
		//	UUTF16֕ϊĖ߂
		utf8 = _cnvU8(_cnvU16((LPCU8STR)unknown));
		if(utf8.IsEmpty())
			return(-1);		//	ϊs\
		return(0);
	}

	//	UUTF16֕ϊĖ߂
	utf8 = _cnvU8((LPCSTR)unknown);
	if(utf8.IsEmpty())
		return(-1);		//	ϊs\
	return(0);
}


//////////////////////////////////////////////////////////////////////
//	URL
//////////////////////////////////////////////////////////////////////
/*!
	IuWFNg؂o
*/
CUTF8String CUrlTools::GetUrlObject(CUTF8String url)
{
	int index = url.Find(_U8("?"));
	if(index == -1)
		return(url);
	else
		return(url.Left(index));
}

/*!
	NG؂o
*/
CUTF8String CUrlTools::GetQuery(CUTF8String url)
{
	int index = url.Find(_U8("?"));
	if(index == -1)
		return(_U8(""));
	else
		return(url.Mid(index + 1));
}


/*!
	URL𐳋K
*/
CUTF8String CUrlTools::NormalizeUrl(CUTF8String url)
{
	//	K"/"Ŏn܂
	if(url.Left(1) != _U8("/"))
		url = _U8("/") + url;

	//	Sׁ̈A\:..r
	int count = url.GetLength();
	for(int i=0; i<count + 10; i++)
	{
		int rep = 0;

		rep += url.Replace(_U8("\\"),	_U8("/"));
		rep += url.Replace(_U8(":"),	_U8("/"));
		rep += url.Replace(_U8("/./"),	_U8("/"));			//	Ǝ㐫FIPA#27428836 2006/06/30 Fix
		rep += url.Replace(_U8("/../"),	_U8("/"));
		rep += url.Replace(_U8("//"),	_U8("/"));
		if(rep == 0)
			break;
	}

	//	ŏIZLeBebN
	if(url.Find(_U8("/../")) != -1)
		return _U8("");

	return url;
}
