/*!
	DateTools.h

	tƕ̑ݕϊs
*/
#pragma once
#include "Time_t.h"

/*!
	 <-> @ݕϊ
*/
class CDateTools  
{
public:
	/*!
		(GMT)
	*/
	static CTime_t StringToCTime_t(CUTF8String time)
	{
		time.TrimLeft();
		time.TrimRight();
		time.MakeLower();

		//	H
		if(time.IsEmpty())
			return(-1);

		int	index = time.Find(_U8(","));
		int	day,year,month,hour,minute,second;

		if(index == -1)
		{
			// Sun Nov  6 08:49:37 1994       ; ANSI C  asctime() tH[}bg

			//	`FbN
			if(time.GetLength() < (int)strlen("Sun Nov  6 08:49:37 1994"))
				return(-1);

			//	DayOfWeek
			time = time.Mid(4);

			//	Month
			month = StrToMonth(time.Left(3));
			time = time.Mid(4);

			//	Day
			day = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);

			//	Hour
			hour = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);

			//	Minute
			minute = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);
			
			//	Second
			second = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);
		
			//	Year
			year = atol(_cnvMBCS(time.Left(4)));

			return(GetTime_t(year, month, day, hour, minute, second, TRUE));
		}
		else if(index > 3)
		{
			// Sunday, 06-Nov-94 08:49:37 GMT ; RFC 850, RFC 1036 ɂ莞x

			//	`FbN
			if(time.GetLength() < (int)strlen("Sunday, 06-Nov-94 08:49:37 GMT"))
				return(-1);

			//	DayOfWeek
			time = time.Mid(index + 2);

			//	Day
			day = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);

			//	Month
			month = StrToMonth(time.Left(3));
			time = time.Mid(4);

			//	Year
			year = atol(_cnvMBCS(time.Left(2))) + 2000;
			time = time.Mid(3);

			//	Hour
			hour = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);

			//	Minute
			minute = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);
			
			//	Second
			second = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);

			return(GetTime_t(year, month, day, hour, minute, second, TRUE));
		}
		else if(index == 3)
		{
			// Sun, 06 Nov 1994 08:49:37 GMT  ; RFC 822, RFC 1123 ŉ肳ꂽ

			//	`FbN
			if(time.GetLength() < (int)strlen("Sun, 06 Nov 1994 08:49:37 GMT"))
				return(-1);

			//	DayOfWeek
			time = time.Mid(index + 2);

			//	Day
			day = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);

			//	Month
			month = StrToMonth(time.Left(3));
			time = time.Mid(4);

			//	Year
			year = atol(_cnvMBCS(time.Left(4)));
			time = time.Mid(5);

			//	Hour
			hour = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);

			//	Minute
			minute = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);
			
			//	Second
			second = atol(_cnvMBCS(time.Left(2)));
			time = time.Mid(3);

			//	Ŝ
			if(year < 1980 || year > 2900)
				return(CTime_t(1980,1,1,1,1,1));

			return(GetTime_t(year, month, day, hour, minute, second, TRUE));
		}
		return(0);
	}


	/*!
		GMTŎ擾
	*/
	static CUTF8String GetGMTString(CTime_t time)
	{
		return(time.FormatGMT(_U8("%a, %d %b %Y %H:%M:%S GMT")));
	}

	/*!
		擾
	*/
	static CUTF8String GetTimeString(CTime_t time)
	{
		return(time.Format(_U8("%Y/%m/%d %H:%M:%S")));
	}

protected:
	/*!
		𐔒l
	*/
	static int StrToMonth(CUTF8String month)
	{
		static wchar_t emonth[12][10]={	_U16("Jan"), _U16("Feb"), _U16("Mar"), _U16("Apr"), _U16("May"), _U16("Jun"),
										_U16("Jul"), _U16("Aug"), _U16("Sep"), _U16("Oct"), _U16("Nov"), _U16("Dec") };
		//	rĂ݂
		for(int i=0;i<12;i++)
			if(month.CompareNoCase(emonth[i]) == 0)
				return(i+1);
		return(1);
	}

	/*!
		CTime_t 
	*/
	static CTime_t GetTime_t(int year, int month, int day, int hour, int minute, int second, int isGMT)
	{
		//	Ŝ
		if(year < 1980 || year > 2900)
			return(CTime_t(1980,1,1,1,1,1));

		//	
		if(	month < 1)	month = 1;
		if(	month > 12)	month = 12;

		//	
		if(	day < 0)	day = 0;
		if(	day > 31)	day = 31;

		//	
		if(	hour < 0)	hour = 0;
		if(	hour > 23)	hour = 23;

		//	
		if(	minute < 0)		minute = 0;
		if(	minute > 59)	minute = 59;

		//	b
		if(	second < 0)		second = 0;
		if(	second > 59)	second = 59;

		//	
		CTime_t ret = CTime_t(year,month,day,hour,minute,second);

		//	␳
		if(isGMT)
			ret.ConvertGMTToLocalTime();

		return(ret);
	}
};
