#include "StdAfx.h"
#include "ExpatXmlParser.h"

CExpatXmlParser::CExpatXmlParser(void)
{
	m_init = FALSE;
}

CExpatXmlParser::~CExpatXmlParser(void)
{
	Close();
}



/////////////////////////////////////////////////////////////////////////////////////
//	Jn
/////////////////////////////////////////////////////////////////////////////////////
/*!
	t@C擾
*/
CString CExpatXmlParser::LoadXmlFile(CString path)
{
	//	J
	FILE	*in;
	if(_tfopen_s(&in, path, _T("rb")) != 0)
		throw CXMLTextParserException("t@C̃I[vɎs܂", 0);
	
	//	TCY擾
	fseek(in, 0, SEEK_END);
	long	len = ftell(in);
	fseek(in, 0, SEEK_SET);

	//	obt@p
	CStringA	ret;
	char	*buf = ret.GetBuffer(len);

	//	ǂݍ
	fread(buf, len, 1, in);
	ret.ReleaseBufferSetLength(len);
	fclose(in);

	return(ret);
}


/*!
	XL
*/
void CExpatXmlParser::StartScan(CStringA xmlUtf8)
{
	//	
	if(Init())
		throw CXMLTextParserException("XMLp[T[̏Ɏs܂", 0);

	//	
	if(XML_Parse(m_parser, xmlUtf8.GetBuffer(0), (int)xmlUtf8.GetLength(), TRUE) != XML_TRUE)
		throw CXMLTextParserException("XML̉͂Ɏs܂", 0);
}


/////////////////////////////////////////////////////////////////////////////////////
//	⏕
/////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
int CExpatXmlParser::Init()
{
	if(!m_init)
	{
		//	
		m_parser = XML_ParserCreate(NULL);
		if(m_parser == NULL)
			return(-1);

		//	[U[f[^Zbg
		XML_SetUserData(m_parser, this);

		//	nhZbg
		XML_SetElementHandler(m_parser, StartElementHandler, EndElementHandler);
		XML_SetCharacterDataHandler(m_parser, CharacterDataHandler);
		m_init = TRUE;
	}
	else
	{
		//	Zbg
		if(XML_ParserReset(m_parser, NULL) != XML_TRUE)
			return(-1);
	}
	return(0);
}

/*!
	I
*/
void CExpatXmlParser::Close()
{
	if(m_init)
	{
		XML_ParserFree(m_parser);
	}
	m_init = FALSE;
}

/*!
	ASCIIȊO܂ނ`FbN
*/
int CExpatXmlParser::CheckUTF8(const XML_Char *str, int len)
{
	unsigned char *ptr = (unsigned char *)str;

	//	
	if(len == -1)
	{
		for(int i=0;*ptr;i++)
		{
			//	UTF8ASCIIȊO
			if(*ptr >= 0x80)
				return(1);
			ptr++;
		}
	}
	else
	{
		for(int i=0;i<len;i++)
		{
			//	UTF8ASCIIȊO
			if(*ptr >= 0x80)
				return(1);
			ptr++;
		}
	}

	return(0);
}


/*!
	Attr`FbN
*/
int CExpatXmlParser::GetAttrCount(LPCSTR *atts)
{
	//	
	int i;
	for(i=0;atts[i];i++)
		;
	return(i);
}


/////////////////////////////////////////////////////////////////////////////////////
//	R[obN
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn^O
*/
void CExpatXmlParser::StartElementHandler(void *userData, const XML_Char *name, const XML_Char **atts)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	SJIS
	name = obj->m_sjis.ConvertToSJIS(name);
	for(int i=0;atts[i];i++)
		atts[i] = obj->m_sjis.ConvertToSJIS(atts[i]);

	//	R[
	obj->OnStartTag(name, atts);

	//	SJISJ
	obj->m_sjis.Cleanup();
//	TRACE("Start %s\n", name);
}

/*!
	I^O
*/
void CExpatXmlParser::EndElementHandler(void *userData, const XML_Char *name)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	SJIS
	name = obj->m_sjis.ConvertToSJIS(name);

	//	R[
	obj->OnEndTag(name);

	//	J
	obj->m_sjis.Cleanup();
//	TRACE("End %s\n", name);
}

/*!
	f[^
*/
void CExpatXmlParser::CharacterDataHandler(void *userData, const XML_Char *s, int len)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	SJIS
	s = obj->m_sjis.ConvertToSJIS(s, len);

	//	R[
	obj->OnData(s, len);

	//	SJISJ
	obj->m_sjis.Cleanup();
}


/////////////////////////////////////////////////////////////////////////////////////
//	CExpatXmlParserUTF8Convert
/////////////////////////////////////////////////////////////////////////////////////
/*!
	RXgN^
*/
CExpatXmlParserUTF8Convert::CExpatXmlParserUTF8Convert() : 
	m_extUtf16Buf(0)
{
	m_sjisBufUsing = 0;
}

/*!
	fXgN^
*/
CExpatXmlParserUTF8Convert::~CExpatXmlParserUTF8Convert()
{
	Cleanup();
}

/*!
	擾
*/
LPCSTR CExpatXmlParserUTF8Convert::ConvertToSJIS(LPCSTR utf8, int &len)
{
	//	ϊ̕Kv͂邩H
	if(!CheckUTF8(utf8, len))
		return(utf8);
	
	//	擾
	if(len == -1)
		len = strlen(utf8);

	//	UTF16̒擾
	int wbLen = MultiByteToWideChar(CP_UTF8, 0, utf8, len, NULL, 0);

	//	UTF16֕ϊ
	wchar_t *utf16 = AllocUTF16Buf(wbLen + 1);
	MultiByteToWideChar(CP_UTF8, 0, utf8, len, utf16, wbLen);

	//	SJIS̒擾
	len = WideCharToMultiByte(CP_ACP, 0, utf16, wbLen, NULL, 0, NULL, NULL);

	//	SJIS
	CHAR *sjis = AllocString(len + 1);
	WideCharToMultiByte(CP_ACP, 0, utf16, wbLen, sjis, len + 1, NULL, NULL);
	sjis[len] = 0;

	return(sjis);
}

/*!
	|
*/
void CExpatXmlParserUTF8Convert::Cleanup()
{
	m_sjisBufUsing = 0;

	//	gobt@폜
	if(m_extSjisBuf.GetSize() > 0)
	{
		for(int i=0;i<m_extSjisBuf.GetSize();i++)
			delete m_extSjisBuf[i];
		m_extSjisBuf.RemoveAll();
	}
}


/*!
	C
*/
LPCSTR CExpatXmlParserUTF8Convert::ToCString(const CHAR *buf, int len)
{
	CHAR *ret = AllocString(len + 1);
	memmove(ret, buf, len);
	ret[len] = 0;

	return(ret);
}

/////////////////////////////////////////////////////////////////////////////////////
//	⏕
/////////////////////////////////////////////////////////////////////////////////////
/*!
	ASCIIȊO܂ނ`FbN
*/
int CExpatXmlParserUTF8Convert::CheckUTF8(LPCSTR str, int len)
{
	unsigned char *ptr = (unsigned char *)str;

	//	
	if(len == -1)
	{
		for(int i=0;*ptr;i++)
		{
			//	UTF8ASCIIȊO
			if(*ptr >= 0x80)
				return(1);
			ptr++;
		}
	}
	else
	{
		for(int i=0;i<len;i++)
		{
			//	UTF8ASCIIȊO
			if(*ptr >= 0x80)
				return(1);
			ptr++;
		}
	}

	return(0);
}

/*!
	m
*/
LPSTR CExpatXmlParserUTF8Convert::AllocString(int len)
{
	//	gɊmۂ̕KvL
	if(len >= EXPAT_SJIS_STRING_BUF_LEN || m_sjisBufUsing >= EXPAT_SJIS_STRING_BUF_COUNT)
		return(AllocExtString(len));

	return(m_sjisBuf[m_sjisBufUsing++]);
}

/*!
	gobt@m
*/
LPSTR CExpatXmlParserUTF8Convert::AllocExtString(int len)
{
	//	obt@m
	CHAR *buf = new CHAR[len];
	m_extSjisBuf.Add(buf);

	return(buf);
}

//!	UTF16obt@擾
wchar_t *CExpatXmlParserUTF8Convert::AllocUTF16Buf(int count)
{
	//	mۂ̕KvȂH
	if(count < EXPAT_UTF16_STRING_BUF_COUNT)
		return(m_utf16Buf);

	//	m
	m_extUtf16Buf.Alloc(count);
	return(m_extUtf16Buf);
}
