#pragma once
#include "responsebase.h"
#include "SortArray.h"
#include "BinaryData.h"
#include "ServerToolWrap.h"

/*!
	fBNgCfbNX X|X
*/
class CDirectoryIndexResponse :
	public CResponseBase
{
public:
	CDirectoryIndexResponse(void);
	virtual ~CDirectoryIndexResponse(void);

	//!	X|X擾(Kstatic̈ɐ錾Ȃ΂ȂȂ)
	virtual LPCTSTR GetResponseName();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|X
	virtual void BuildResponse(CIConnectionToolWrap responseContext);

	//!	X|Xwb_擾
	virtual void GetResponse(CIConnectionToolWrap responseContext);

	//!	X|X{fB擾
	virtual int GetResponseBody(CIConnectionToolWrap responseContext, CBinaryData &body, int blockSize);

	//!	폜
	virtual void Delete() { delete this; };

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	t@CACeNX
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	\[g[h
	enum
	{
		SORT_BY_NAME = 0,
		SORT_BY_DATE = 1,
		SORT_BY_SIZE = 2,
	};

	//!	t@CACeNX
	class CFileItem
	{
	public:
		//!	RXgN^
		CFileItem() { m_sortMode = 0; };

		//!	RXgN^
		CFileItem(CString name, CTime lastUpdate, __int64 size, int sortMode)
		{
			m_name = name;
			m_lastUpdate = lastUpdate;
			m_size = size;
			m_sortMode = sortMode;
		};

		//!	r
		int operator > (CFileItem &other)
		{
			switch(m_sortMode)
			{
			case SORT_BY_DATE:
				return m_lastUpdate > other.m_lastUpdate;
			case SORT_BY_SIZE:
				return m_size > other.m_size;
			case SORT_BY_NAME:
			default:
				return m_name > other.m_name;
			}
		};

		//!	t@C
		CString		m_name;

		//!	ŏIXV
		CTime		m_lastUpdate;

		//!	TCY
		__int64		m_size;

		//!	\[g[h
		int			m_sortMode;
	};

	//!	z^
	typedef CSortArray<CFileItem,CFileItem&>	CFileItemArray;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	t@CXg̎擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	t@CXg
	void BuildFileList(CIConnectionToolWrap responseContext, CBinaryData &fileListHtml);

	//!	sǉ
	void AddListLine(CBinaryData &fileListHtml, CString name, CString path, CString iconPath, __int64 size = -1, CTime updateTime = 0);

	//!	HTML[h
	CString LoadHtml(CIConnectionToolWrap responseContext);

	//!	NXg̎擾
	void GetLinkList(CIConnectionToolWrap responseContext, CFileItemArray & list, int sortMode=-1);

	//!	fBNgXg̎擾
	void GetDirectoryList(CFileItemArray &directoryList, CFileItemArray &fileList, CString targetDir, int showHiddenFile, int sortMode=-1);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|X{fB
	CString	m_responseBody;
};


/*!
	fBNgCfbNX X|Xt@Ng
*/
class  CDirectoryIndexResponseFactory :
	public CResponseFactoryBase
{
public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	̃ACeH
	virtual int IsYourRequest(CContext context);

	//!	X|X擾
	virtual IResponsePtr GetResponse() { return (new CDirectoryIndexResponse())->GetIResponse(); };

	//!	폜
	virtual void Delete() { delete this; };
};
