#include "StdAfx.h"
#include "ConnectionManager.h"
#include "ServerException.h"

#define	CLASS_NAME	"ConnectionManager"

CConnectionManager::CConnectionManager(void)
{
}

CConnectionManager::~CConnectionManager(void)
{
	Stop();
}



/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CConnectionManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;

	//	Rs[A
	m_serverTool = serverTool;
	m_endThreadCount = 0;
	m_connectionID = 0;


	//	ݒ擾
	m_setting = m_serverTool.GetManagerSetting(m_setting.GetSettingName());

	//	ݒ菉
	int maxConnect = m_setting.GetMaxConnect();
	m_maxThreads = maxConnect;

	//	L[
	m_queue.SetMaxQueue(maxConnect); //	őڑݒ肷
	m_queue.Start();

	//	I[o[[h
	m_overload.Start(m_serverTool.GetIServerTool(), maxConnect, m_setting.GetOverloadModeKeepTime());

	//	ReLXg
	m_context.Start(m_serverTool.GetIServerTool());

	//	XbhN
	if(StartThread())
		throw CServerStartErrorException(CLASS_NAME, "Xbh̋NɎs܂");

	//	
	m_init = TRUE;

	//	ŏIXe[^X
	m_serverTool.WriteSystemLog(CLASS_NAME, SYSTEM_LOG_INFO, "ڑ}l[WN܂");
}

/*!
	~
*/
void CConnectionManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	Xbh~
	EndThread();

	//	SXbh폜
	m_threads.RemoveAll();

	//	ReLXg~
	m_context.Stop();

	//	I[o[[h}l[W~
	m_overload.Stop();

	//	҂󂯃L[~
	m_queue.Stop();

	//	ŏIXe[^X
	m_serverTool.WriteSystemLog(CLASS_NAME, SYSTEM_LOG_INFO, "ڑ}l[W~܂");
}


/////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh
*/
void CConnectionManager::ThreadMain()
{
	//	ڑ[v
	while(!GetBreak())
	{
		//	
		if(InMaxThreads())
		{
			//	Ƒ҂
			WaitForSomeObjects(100, GetBreakEvent());
		}
		else
		{
			//	ڑ҂
			if(WaitForSomeObjects(500, m_queue.GetSemaphore(), GetBreakEvent()) == 1)
				CreateNewThread(CIClientConnectionWrapper::CreateWrapper(m_queue.GetNewConnection()));
		}

		//	GC
		DeleteEndThreads();

		//	T[oאݒ
		m_overload.UpdateServerload(GetThreadCount(), m_queue.GetCurrentQueueCount());
	}
}


/*!
	Vڑǉ
*/
void CConnectionManager::CreateNewThread(CIClientConnectionWrapper connection)
{
	SCOPE_LOCK();

	//	H
	if(connection.IsEmpty())
		return;

	try
	{
		//	
		CConnectionThreadPtr thread(new CConnectionThread());
		if(thread->Start(	m_serverTool.GetIServerTool(),
							IConnectionThreadParentRet(this, FALSE),
							m_context.GetIConetextGene(),
							connection,
							m_connectionID++))
			m_serverTool.WriteSystemLog(CLASS_NAME, SYSTEM_LOG_ERROR, "Xbh̋NɎs܂");

		//	ǉ
		m_threads.AddTail(thread);
	}
	catch(CMemoryException *err)
	{
		//	
		m_serverTool.WriteSystemLog(CLASS_NAME, SYSTEM_LOG_ERROR, "s܂");

		//	ҋ@
		err->Delete();
		Sleep(1000);
	}
}

/*!
	ڑЕt

	EndConnectionĂ΂ꂽ_ł́A܂XbhIĂȂ߁A|[OKv
*/
void CConnectionManager::DeleteEndThreads()
{
	SCOPE_LOCK();

	//	sv
	if(m_endThreadCount == 0)
		return;

	//	č폜
	POSITION pos = m_threads.GetHeadPosition();
	while(pos)
	{
		//	IH
		if(!m_threads.GetAt(pos)->IsRunning())
		{
			//	폜
			POSITION	del = pos;
			m_threads.GetNext(pos);
			m_threads.RemoveAt(del);
		}
		else
			m_threads.GetNext(pos);
	}

	m_endThreadCount = 0;
}

/*!
	őڑɓBH
*/
int CConnectionManager::InMaxThreads()
{
	SCOPE_LOCK();

	//	őXbhɓBH
	if(m_threads.GetSize() >= m_maxThreads)
		return(TRUE);
	return(FALSE);
}

/*!
	ڑ擾
*/
int CConnectionManager::GetThreadCount()
{
	SCOPE_LOCK();

	return(m_threads.GetSize());
}

/////////////////////////////////////////////////////////////////////////////////////
//	IConnectionThreadParent
/////////////////////////////////////////////////////////////////////////////////////
/*!
	XbhI
*/
void CConnectionManager::EndConnection(CConnectionThread *connectionPtr)
{
	SCOPE_LOCK();

	m_endThreadCount++;
}

/*!
	I[o[[h
*/
int CConnectionManager::InOverloadMode()
{
	return m_overload.InOverloadMode();
}

