#pragma once
#include "iresponse.h"
#include "ConnectionToolWrap.h"
#include "BinaryData.h"


/*!
	X|Xt@Ng x[X
*/
class CResponseFactoryBase
{
public:
	//!	RXgN^
	CResponseFactoryBase(void)
	{
		m_interface.SetResponseFactoryBase(this);
	}

	//!	fXgN^
	virtual ~CResponseFactoryBase(void)
	{
	}

	//!	C^tF[X擾
	IResponseFactoryPtr GetIResponseFactory()
	{
		return &m_interface;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void Start(CIServerToolWrap serverTool) {};

	//!	~
	virtual void Stop() {};

	//!	폜
	virtual void Delete() {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	̃ACeH
	virtual int IsYourRequest(CContext context) = 0;

	//!	X|X擾
	virtual IResponsePtr GetResponse() = 0;

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|XC^tF[X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|XC^tF[X
	class CResponseFactoryInterface : public IResponseFactory
	{
	public:
		CResponseFactoryInterface()
		{
			m_responseFactory = NULL;
		}

		//!	Zbg
		void SetResponseFactoryBase(CResponseFactoryBase *responseFactory)
		{
			m_responseFactory = responseFactory;
		}

		//!	
		virtual void Start(IServerToolPtr serverTool)
		{
			m_responseFactory->Start(serverTool);
		}

		//!	~
		virtual void Stop()
		{
			m_responseFactory->Stop();
		}

		//!	폜
		virtual void Delete()
		{
			m_responseFactory->Delete();
		}

		//!	̃ACeH
		virtual int IsYourRequest(IWorkspaceAccessPtr context)
		{
			return m_responseFactory->IsYourRequest(CWorkspaceAccess(context));
		}

		//!	X|X擾
		virtual IResponsePtr GetResponse()
		{
			return m_responseFactory->GetResponse();
		}

	protected:
		//////////////////////////////////////////////////////////////////////////////////////////////
		//	oϐ
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	
		CResponseFactoryBase	*m_responseFactory;
	};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X
	CResponseFactoryInterface	m_interface;
};


/*!
	X|X x[X
*/
class CResponseBase
{
public:
	//!	RXgN^
	CResponseBase(void)
	{
		m_interface.SetFilterBase(this);
	};

	//!	fXgN^
	virtual ~CResponseBase(void)
	{
	};

	//!	C^tF[X擾
	IResponsePtr GetIResponse()
	{
		return &m_interface;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	(OցI)
	virtual void Start(CIConnectionToolWrap responseContext) {};

	//!	~(OցI)
	virtual void Stop(CIConnectionToolWrap responseContext)  {};

	//!	폜
	virtual void Delete() {};

	//!	tB^擾
	virtual LPCTSTR GetResponseName() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	1:NGXgwb_ݒ
	virtual void SetRequest(CIConnectionToolWrap responseContext) {};

	//!	2:NGXg{fBݒ(JԂ)
	virtual void SetRequestBody(CIConnectionToolWrap responseContext, CBinaryData &body) {};

	//!	3:NGXg
	virtual void EndRequest(CIConnectionToolWrap responseContext) {};


	//!	4:X|X
	virtual void BuildResponse(CIConnectionToolWrap responseContext) {};


	//!	5:X|Xwb_擾
	virtual void GetResponse(CIConnectionToolWrap responseContext) {};

	//!	6:X|X{fB擾
	virtual int GetResponseBody(CIConnectionToolWrap responseContext, CBinaryData &body, int blockSize) { return 0; };

	//!	7:X|X
	virtual void EndResponse(CIConnectionToolWrap responseContext) {};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|XC^tF[X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|XC^tF[X
	class CResponseInterface : public IResponse
	{
	public:
		//!	RXgN^
		CResponseInterface()
		{
			m_responseBase = NULL;
		}

		//!	Zbg
		void SetFilterBase(CResponseBase *responseBase)
		{
			m_responseBase = responseBase;
		}

		//////////////////////////////////////////////////////////////////////////////////////////////
		//	
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	(OցI)
		virtual void Start(IConnectionToolPtr responseContext)
		{
			m_responseBase->Start(responseContext);
		}

		//!	~(OցI)
		virtual void Stop(IConnectionToolPtr responseContext)
		{
			m_responseBase->Stop(responseContext);
		}

		//!	X|X擾(Kstatic̈ɐ錾Ȃ΂ȂȂ)
		virtual LPCTSTR GetResponseName()
		{
			return m_responseBase->GetResponseName();
		}

		//!	폜
		virtual void Delete()
		{
			m_responseBase->Delete();
		}

		//////////////////////////////////////////////////////////////////////////////////////////////
		//	X|X
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	1:NGXgwb_ݒ
		virtual void SetRequest(IConnectionToolPtr responseContext)
		{
			m_responseBase->SetRequest(responseContext);
		}

		//!	2:NGXg{fBݒ(JԂ)
		virtual void SetRequestBody(IConnectionToolPtr responseContext, IBinaryDataPtr body)
		{
			m_responseBase->SetRequestBody(responseContext, CBinaryData(body));
		}

		//!	3:NGXg
		virtual void EndRequest(IConnectionToolPtr responseContext)
		{
			m_responseBase->EndRequest(responseContext);
		}

		//!	4:X|X
		virtual void BuildResponse(IConnectionToolPtr responseContext)
		{
			m_responseBase->BuildResponse(responseContext);
		}

		//!	5:X|Xwb_擾
		virtual void GetResponse(IConnectionToolPtr responseContext)
		{
			m_responseBase->GetResponse(responseContext);
		}

		//!	6:X|X{fB擾
		virtual int GetResponseBody(IConnectionToolPtr responseContext, IBinaryDataPtr body, int blockSize)
		{
			return m_responseBase->GetResponseBody(responseContext, CBinaryData(body), blockSize);
		}

		//!	7:X|X
		virtual void EndResponse(IConnectionToolPtr responseContext)
		{
			m_responseBase->EndResponse(responseContext);
		}

	protected:
		//////////////////////////////////////////////////////////////////////////////////////////////
		//	oϐ
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	
		CResponseBase	*m_responseBase;
	};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X
	CResponseInterface	m_interface;
};
