/*!
	T[oc[C^tF[X
*/

#pragma once
#include "InterfaceWrapperMacro.h"
#include "IManagerInterface.h"
#include "Workspace.h"

#define	MANAGER_SETTING		_T("ManagerSetting")
#define	FILTER_SETTING		_T("FilterSetting")
#define	RESPONSE_SETTING	_T("ResponseSetting")
#define	SERVER_STATUS		_T("ServerStatus")
#define	SERVER_INFO			_T("ServerInfo")

//!	C^[tF[X錾
class IPathManager;
class IMimeTypeManager;
class ILogManager;
class IServerTextManager;
class ICGIManager;

typedef IServerTextManager* IServerTextManagerPtr;
typedef ILogManager*		ILogManagerPtr;
typedef IMimeTypeManager*	IMimeTypeManagerPtr;
typedef ICGIManager*		ICGIManagerPtr;

//!	O^Cv
enum
{
	//!	\̂݁At@Cɂ͋L^Ȃ
	SYSTEM_LOG_INFO				= 100,

	//!	t@CɋL^郍O
	SYSTEM_LOG_INFO_LOG			= 0,

	//!	x
	SYSTEM_LOG_WARNING			= -100,

	//!	G[
	SYSTEM_LOG_ERROR			= -200,

	//!	vIG[
	SYSTEM_LOG_FATAL_ERROR		= -300,
};

//!	bZ[W^Cv
enum
{
	//!	
	SYSTEM_MESSAGE_OFF			= 0,

	//!	
	SYSTEM_MESSAGE_INFO			= 100,

	//!	
	SYSTEM_MESSAGE_WARNING		= 200,

	//!	ԕ
	SYSTEM_MESSAGE_ERROR		= 300,
};


/*!
	T[opc[
*/
class IServerTool
{
public:
	//!	fXgN^
	virtual ~IServerTool() {};

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^XEO
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oȌ
	virtual void WriteSystemLog(LPCSTR callerName, int logType, LPCSTR logString) = 0;

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatus(LPCSTR statusName, LPCSTR status, LPCSTR statusInfo = "", LPCSTR statusType = "String") = 0;

	//!	T[obZ[Wʒm
	virtual void NotifyServerMessage(LPCSTR messageID, LPCSTR message, int messageType, int autoOffTimeSec = -1) = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	[NXy[Xւ̃ANZX擾
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	[NXy[Xւ̃ANZX擾
	virtual int GetServerWorkspaceAccess(IWorkspaceAccessRefPtr accessRef, LPCSTR type, LPCSTR section) = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[XǗ
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[Xo^
	virtual int RegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface = NULL) = 0;

	//!	C^[tF[Xo^
	virtual int UnRegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface = NULL) = 0;

	//!	C^tF[X擾
	virtual void *GetManagerInterface(LPCSTR interfaceName, int ifVersion) = 0;
};
//!	|C^^
typedef IServerTool* IServerToolPtr;



/*!
	T[op
*/
class IServerControl
{
public:
	//!	fXgN^
	virtual ~IServerControl() {};

	//!	T[o̊Jn
	virtual void StartServer() = 0;

	//!	T[o̒~
	virtual void StopServer() = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	̎擾
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ReLXg擾
	virtual void DuplicateCurrentContext(CWorkspace &contextRoot) = 0;

	//!	T[oXe[^X擾
	virtual void DuplicateServerStatus(CWorkspace &statusRoot) = 0;
};
//!	|C^^
typedef IServerControl* IServerControlPtr;
