#include "StdAfx.h"
#include "SettingTextParser.h"
#include "TextTools.h"

/*!
	p[X
*/
void CSettingTextParser::ParseText(CString text, CSettingTextParserItemArray &parsed)
{
	//	O
	text.Replace("\r\n","\n");
	text.Replace("\r","\n");
	text.Replace("\n","\r\n");
	parsed.RemoveAll();

	int lineCounter = 0;
	CString	line;
	while(CTextTools::GetLine(text,line))
		ParseLine(line, parsed, lineCounter++);
}

///////////////////////////////////////////////////////////////////
//	c[
///////////////////////////////////////////////////////////////////
/*!
	1s
*/
void CSettingTextParser::ParseLine(CString line, CSettingTextParserItemArray &parsed, int lineCount)
{
	//	O
	line.Trim();
	line.Replace("\t",",");
	line.Replace(" ",",");

	//	Rg
	if(line.IsEmpty() || line.Left(1) == "#" || line.Left(2) == "//")
		return;

	//	
	CStringArray	tokens;
	CTextTools::GetAllToken(line, tokens, ",");

	//	|
	for(int i=tokens.GetCount()-1; i>=0; i--)
	{
		tokens[i].Trim();
		if(tokens[i].IsEmpty())
			tokens.RemoveAt(i);
	}

	//	
	CSettingTextParserItem	add;
	add.m_keyText = tokens[0];
	if(tokens.GetSize() > 1)
	{
		tokens.RemoveAt(0);
		add.m_dataArray.Copy(tokens);
	}
	parsed.Add(add);
}

