#pragma once
#include "IServerTool.h"
#include "IMimeTypeManager.h"
#include "Settings.h"
#include "SyncObject.h"
#include "SortArray.h"

class CMimeTypeManager : protected IMimeTypeManager
{
public:
	CMimeTypeManager(void);
	virtual ~CMimeTypeManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(IServerToolPtr serverTool);

	//!	~
	void Stop();

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IMimeTypeManager擾
	virtual IMimeTypeManagerPtr GetIMimeTypeManager() { return IMimeTypeManagerRet(this, FALSE); };

protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	IMimeTypeManager
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	t@CMimeType擾
	virtual CString GetMimeTypeByName(CString name);

	//!	t@CACRpX擾
	virtual CString GetIconPathByName(CString name);

	///////////////////////////////////////////////////////////////////////////////////////////
	//	c[֐
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	MimeType[h
	void LoadMimeType();

	//!	Icon[h
	void LoadIcon();

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection					m_scopeLock;

	//!	tO
	CInterlockCounter					m_init;

	//!	IServerTool
	IServerToolPtr						m_serverTool;

	//!	Mime^Cvݒ
	CMimeTypeManagerSetting				m_mimeTypeSetting;


	//!	MmeTypeƃf[^
	CMapStringToString					m_mimeTypeMap;

	//!	Iconƃf[^
	CKeyDataArray						m_iconArray;
};

