#include "StdAfx.h"
#include "LogManager.h"
#include "ServerStartErrorException.h"
#include "Dir.h"

#define	CLASS_NAME	"LogManager"
#define	MAX_LOG_CACHE	50000

CLogManager::CLogManager(void)
{
}

CLogManager::~CLogManager(void)
{
	Stop();
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CLogManager::Start(IServerToolPtr serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	Rs[A
	m_serverTool = serverTool;

	//	ݒ擾
	m_setting = m_serverTool->GetManagerSetting(m_setting.GetSettingName());

	//	ݒ菉
	m_intervalTime = m_setting.GetUpdateInterval();

	//	XbhN
	if(StartThread())
		throw CServerStartErrorException(CLASS_NAME, "Xbh̋NɎs܂");
}

/*!
	~
*/
void CLogManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	Xbh~
	EndThread();
}

/*!
	ANZXOo
*/
void CLogManager::WriteAccessLog(CString filePath, CString log)
{
	SCOPE_LOCK();

	//	`FbN
	if(m_logList.GetSize() > MAX_LOG_CACHE)
		return;
	m_logList.AddTail(CLogManagerEntry(filePath, log));
}


/////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh
*/
void CLogManager::ThreadMain()
{
	while(!GetBreak())
	{
		//	ҋ@
		WaitForSomeObjects(m_intervalTime, GetBreakEvent());

		//	Ofo
		FlashLog();
	}
}

/*!
	Oo
*/
void CLogManager::FlashLog()
{
	SCOPE_LOCK();

	while(!m_logList.IsEmpty())
	{
		//	fBNg쐬
		CString	dir = CPathTools::PathToDir(m_logList.GetHead().m_filePath);
		if(m_oldDir != dir)
		{
			CFileDirTools::MakeAllDirectory(dir);
			m_oldDir = dir;
		}

		//	t@CJ
		FILE	*log;
		if(fopen_s(&log, m_logList.GetHead().m_filePath, "at+"))
			log = NULL;	//	G[t@C͖

		//	o
		WriteLogs(log, m_logList.GetHead().m_filePath);

		//	
		if(log != NULL)
			fclose(log);
	}
}


/*!
	Ot@C
	t@CpXo
*/
void CLogManager::WriteLogs(FILE *log, CString filePath)
{
	POSITION	pos = m_logList.GetHeadPosition();
	while(pos)
	{
		//	t@CpX͈vH
		if(m_logList.GetAt(pos).m_filePath == filePath)
		{
			if(log != NULL)
			{
				//	OGXP[v
				CString	slog = m_logList.GetAt(pos).m_log;
				slog.Replace("\n", "");
				slog.Replace("\r", "");

				//	o
				fprintf_s(log, "%s\n", slog);
			}

			//	폜Ď擾
			POSITION	del = pos;
			m_logList.GetNext(pos);
			m_logList.RemoveAt(del);
		}
		else
		{
			//	擾
			m_logList.GetNext(pos);
		}
	}
}
