/*!
	IFilter

	tB^ׂ̎C^tF[X
*/

#pragma once
#include "IServerTool.h"
#include "IConnectionControl.h"
#include "Context.h"

class IFilter;
class IFilterContext;

//!	C^[tF[X`
DEFINE_INTERFACE(IFilter);
DEFINE_INTERFACE_NOWRAP(IFilterContext);

/*!
	tB^ReLXg
*/
class IFilterContext
{
public:
	virtual ~IFilterContext() {};

	//!	C^tF[X擾
	virtual IFilterContextPtr GetIFilterContext() = 0;

	//!	T[oc[擾
	virtual IServerToolPtr GetIServerTool() = 0;

	//!	XbhXe[^X擾
	virtual IConnectionThreadStatusPtr GetIConnectionThreadStatus() = 0;

	//!	ڑ擾
	virtual IConnectionControlPtr GetIConnectionControl() = 0;
		
	//!	ReLXg擾
	virtual CContext GetContxet() = 0;
};


/*!
	tB^
*/
class IFilter
{
public:
	virtual ~IFilter(void)
	{
	}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	(OցI)
	virtual void Start(IFilterContextPtr filterContext) = 0;

	//!	tB^擾
	virtual LPCTSTR GetFilterName() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	NGXgM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_
	virtual void FilterRequestHeader(IFilterContextPtr filterContext, CContextRequestInfo &requestInfo) = 0;

	//!	{fBMAJԂ(throw)
	virtual void FilterRequestBody(IFilterContextPtr filterContext, CBinaryData &body) = 0;

	//!	M
	virtual void FilterEndRequest(IFilterContextPtr filterContext) = 0;


	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|X
	virtual void FilterBuildResponse(IFilterContextPtr filterContext) = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|XM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_
	virtual void FilterResponseHeader(IFilterContextPtr filterContext, CContextResponseInfo &responseInfo) = 0;

	//!	{fB𑗐MAJԂ(throw)
	virtual void FilterResponseBody(IFilterContextPtr filterContext, CBinaryData &body) = 0;

	//!	M
	virtual void FilterEndResponse(IFilterContextPtr filterContext) = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	T[oX|XM(O)
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_(OցI)
	virtual void FilterServerResponse(IFilterContextPtr filterContext, CContextResponseInfo &responseInfo, CBinaryData &body) = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	~
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	ؒf(OցI)
	virtual void Stop(IFilterContextPtr filterContext) = 0;
};


/*!
	tB^NX
*/
class IFilterFactory
{
public:
	virtual ~IFilterFactory(void){}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void StartFactory(IServerToolPtr serverTool) = 0;


	//!	~
	virtual void StopFactory() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	virtual IFilterPtr GetFilter() = 0;
};

//!	C^[tF[X`
DEFINE_INTERFACE(IFilterFactory);

