#pragma once

#include "ManagedInterfaceBasicInterfaces.h"


class CWorkspaceAccess
{
public:
	CWorkspaceAccess(void);
	CWorkspaceAccess(IWorkspaceAccessPtr access);
	CWorkspaceAccess(IWorkspacePtr root, CString path);
	virtual ~CWorkspaceAccess(void);


	/////////////////////////////////////////////////////////////////////////////
	//	Ȃ
	/////////////////////////////////////////////////////////////////////////////
	//!	Sf[^NA
	virtual void Clear(void);

	//!	(㏑Rs[ATum[hƃL[Rs[邪Ãm[h͕ύXȂ)
	virtual void Copy(CWorkspaceAccess &src);

	//!	ANZXNX擾
	virtual CWorkspaceAccess GetAccess(CString subPath);

	//!	[g擾
	virtual IWorkspacePtr GetRoot();

	//!	O擾
	virtual CString GetNodeName();

	//!	pX擾
	virtual CString GetPath();

	/////////////////////////////////////////////////////////////////////////////
	//	KeyɊւ鏈
	/////////////////////////////////////////////////////////////////////////////
	//!	f[^̐ݒ
	virtual void SetKeyStr(CString key, CString data,int noCase=FALSE);
	virtual void SetKeyInt(CString key, int data,int noCase=FALSE);
	virtual void SetKeyInt64(CString key, __int64 data,int noCase=FALSE);
	virtual void SetKeyDWORD(CString key, DWORD data,int noCase=FALSE);

	//!	f[^̎擾
	virtual CString GetKeyStr(CString key, CString defaultData,int noCase=FALSE);
	virtual int GetKeyInt(CString key, int defaultData,int noCase=FALSE);
	virtual __int64 GetKeyInt64(CString key, __int64 defaultData,int noCase=FALSE);
	virtual DWORD GetKeyDWORD(CString key, DWORD defaultData,int noCase=FALSE);

	//!	f[^̍폜
	virtual void DeleteKey(CString key);

	//!	L[擾
	virtual int GetKeyCount();

	//!	SẴL[𕶎ƂĎ擾
	virtual int GetAllKey(CStringArray &list);

	//!	SẴf[^𕶎ƂĎ擾
	virtual int GetAllData(CStringArray &list);


	/////////////////////////////////////////////////////////////////////////////
	//	Tum[hɊւ鏈
	/////////////////////////////////////////////////////////////////////////////
	//!	m[h폜
	virtual void DeleteNode(CString name);

	//!	Tum[h𓾂
	virtual int GetSubNodeCount();

	//!	SẴTum[h𕶎ƂĎ擾
	virtual int GetAllSubNode(CStringArray &list);

protected:
	/////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////
	//!	
	void Init(IWorkspacePtr root, CString path);

	/////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////
	CString			m_path;
	IWorkspacePtr	m_root;
};


/*!
	⏕NX
*/
class CWSIStringWrap : public IString
{
public:
	//!	RXgN^
	CWSIStringWrap(CString str = "") { m_str = str; };

	//!	ݒ
	virtual void SetString(LPCSTR str) { m_str = str; };

	//!	擾
	virtual LPCSTR GetString() { return m_str; };

	//!	H
	int IsEmpty() { return m_str.IsEmpty(); };

protected:
	CString	m_str;
};


/*!
	z⏕NX
*/
class CWSIStringArrayWrap : public IStringArray
{
public:
	CWSIStringArrayWrap(CStringArray &arr) :
	  m_array(arr)
	{
	};

	//!	
	virtual void Clear()
	{
		m_array.RemoveAll();
	};

	//!	TCYݒ
	virtual void SetSize(int size)
	{
		m_array.SetSize(size);
	};

	//!	TCY擾
	virtual int GetSize()
	{
		return m_array.GetSize();
	};

	//!	ێĂ镶擾
	virtual void AddString(LPCSTR str)
	{
		m_array.Add(str);
	};

	//!	ێĂ镶擾
	virtual LPCSTR GetString(int index)
	{
		return m_array[index];
	};

	//!	ێĂ镶擾
	virtual void SetString(int index, LPCSTR str)
	{
		m_array[index] = str;
	};

protected:
	CStringArray	&m_array;
};


//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_STR(PropertyName, PropertyPath, DefaultVal) \
	CString Get##PropertyName(CString defVal = DefaultVal)	{ return GetKeyStr(PropertyPath, defVal); }; \
	void Set##PropertyName(CString val)	{ SetKeyStr(PropertyPath, val); };	\
	void Clear##PropertyName()	{ SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_INT(PropertyName, PropertyPath, DefaultVal)	\
	int Get##PropertyName(int defVal = DefaultVal)	{ return GetKeyInt(PropertyPath, defVal); }; \
	void Set##PropertyName(int val)	{ SetKeyInt(PropertyPath, val); };	\
	void Clear##PropertyName()	{ SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_INT64(PropertyName, PropertyPath, DefaultVal)	\
	__int64 Get##PropertyName(__int64 defVal = DefaultVal)	{ return GetKeyInt64(PropertyPath, defVal); }; \
	void Set##PropertyName(__int64 val)	{ SetKeyInt64(PropertyPath, val); };	\
	void Clear##PropertyName()	{ SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_WORKSPACE(PropertyName, PropertyPath)	\
	int Get##PropertyName()	{ return GetAccess(PropertyPath); };


//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_STR(Access, PropertyName, PropertyPath, DefaultVal) \
	CString Get##PropertyName(CString defVal = DefaultVal)	{ return Access.GetKeyStr(PropertyPath, defVal); }; \
	void Set##PropertyName(CString val)	{ Access.SetKeyStr(PropertyPath, val); };	\
	void Clear##PropertyName()	{ Access.SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !Access.GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_INT(Access, PropertyName, PropertyPath, DefaultVal)	\
	int Get##PropertyName(int defVal = DefaultVal)	{ return Access.GetKeyInt(PropertyPath, defVal); }; \
	void Set##PropertyName(int val)	{ Access.SetKeyInt(PropertyPath, val); };	\
	void Clear##PropertyName()	{ Access.SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !Access.GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_INT64(Access, PropertyName, PropertyPath, DefaultVal)	\
	__int64 Get##PropertyName(__int64 defVal = DefaultVal)	{ return Access.GetKeyInt64(PropertyPath, defVal); }; \
	void Set##PropertyName(__int64 val)	{ Access.SetKeyInt64(PropertyPath, val); };	\
	void Clear##PropertyName()	{ Access.SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !Access.GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_WORKSPACE(PropertyName, PropertyPath)	\
	int Get##PropertyName()	{ return Access.GetAccess(PropertyPath); };


//!	RXgN^܂Ƃ߂Ē`
#define	DEFINE_COMMON_CONSTRUCTOR(className)	\
	className(void) {};\
	className(CWorkspaceAccess  &other)							{ CWorkspaceAccess::operator=(other); };\
	void operator = (CWorkspaceAccess &other)					{ CWorkspaceAccess::operator=(other); };

