#include "StdAfx.h"
#include "ExpatXmlParser.h"
#include "UTF8StringConvert.h"
#include "BinaryData.h"

CExpatXmlParser::CExpatXmlParser(void)
{
	m_init = FALSE;
}

CExpatXmlParser::~CExpatXmlParser(void)
{
	Close();
}



/////////////////////////////////////////////////////////////////////////////////////
//	Jn
/////////////////////////////////////////////////////////////////////////////////////
/*!
	t@C擾
*/
CUTF8String CExpatXmlParser::LoadXmlFile(CUTF8String path)
{
	//	J
	CBinaryData	load;
	if(load.LoadFromFile(path))
		throw CXMLTextParserException(_U16("t@C̃I[vɎs܂"));

	return(load);
}


/*!
	XL
*/
void CExpatXmlParser::StartScan(CUTF8String xmlUtf8)
{
	//	
	if(Init())
		throw CXMLTextParserException(_U16("XMLp[T[̏Ɏs܂"));

	//	
	if(XML_Parse(m_parser, (const XML_Char*)xmlUtf8.GetString(), (int)xmlUtf8.GetLength(), TRUE) != XML_TRUE)
		throw CXMLTextParserException(_U16("XML̉͂Ɏs܂"));
}


/////////////////////////////////////////////////////////////////////////////////////
//	⏕
/////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
int CExpatXmlParser::Init()
{
	if(!m_init)
	{
		//	
		m_parser = XML_ParserCreate(NULL);
		if(m_parser == NULL)
			return(-1);

		//	[U[f[^Zbg
		XML_SetUserData(m_parser, this);

		//	nhZbg
		XML_SetElementHandler(m_parser, StartElementHandler, EndElementHandler);
		XML_SetCharacterDataHandler(m_parser, CharacterDataHandler);
		m_init = TRUE;
	}
	else
	{
		//	Zbg
		if(XML_ParserReset(m_parser, NULL) != XML_TRUE)
			return(-1);
	}
	return(0);
}

/*!
	I
*/
void CExpatXmlParser::Close()
{
	if(m_init)
	{
		XML_ParserFree(m_parser);
	}
	m_init = FALSE;
}


/*!
	Attr`FbN
*/
int CExpatXmlParser::GetAttrCount(const XML_Char **atts)
{
	//	
	int i;
	for(i=0;atts[i];i++)
		;
	return(i);
}


/////////////////////////////////////////////////////////////////////////////////////
//	R[obN
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn^O
*/
void CExpatXmlParser::StartElementHandler(void *userData, const XML_Char *name, const XML_Char **atts)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	R[
	obj->OnStartTag((LPCU8STR)name, (LPCU8STR*)atts, CExpatXmlParser::GetAttrCount(atts));
}

/*!
	I^O
*/
void CExpatXmlParser::EndElementHandler(void *userData, const XML_Char *name)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	R[
	obj->OnEndTag((LPCU8STR)name);
}

/*!
	f[^
*/
void CExpatXmlParser::CharacterDataHandler(void *userData, const XML_Char *s, int len)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	R[
	obj->OnData((const utf8_char*)s, len);
}

