#include "StdAfx.h"
#include "UTF8StringTool.h"

////////////////////////////////////////////////////////////////////////////////
//	⏕
////////////////////////////////////////////////////////////////////////////////
/*!
	󕶎Ԃ
*/
LPCU8STR CUTF8StringTool::GetEmptyString()
{
	static utf8_char empty[1] = { 0 };

	return(empty);
}

/*!
	󕶎Ԃ
*/
LPCSTR CUTF8StringTool::GetEmptyStringMB()
{
	return((LPCSTR)GetEmptyString());
}

/*!
	󕶎Ԃ
*/
LPCWSTR CUTF8StringTool::GetEmptyStringU16()
{
	static wchar_t empty[1] = { 0 };

	return(empty);
}


////////////////////////////////////////////////////////////////////////////////
//	ϊ
////////////////////////////////////////////////////////////////////////////////
/*!
	UTF8S`FbN

	\return TRUIE:ُ킪
*/
int CUTF8StringTool::CheckIllegalUTF8(LPCU8STR utf8, int length)
{
	//	NULL?
	if(utf8 == NULL)
		return(FALSE);

	//	TCY
	if(length < 0)
		length = strlen((char *)utf8);

	//	oCgI[_[}[N邩H
	if(length >= 3 && utf8[0] == 0xEF && utf8[1] == 0xBB && utf8[2] == 0xBF)
	{
		TRACE_U8(_U16("CheckIllegalUTF8: oCgI[_[}[No܂\n"));
		return(TRUE);
	}

	//	UTF8̏`FbN
	if(!CheckIsUTF8((LPCSTR)utf8, length))
	{
		TRACE_U8(_U16("CheckIllegalUTF8: UTF8̃V[PXɏ]Ă܂\n"));
		return(TRUE);
	}

	const utf8_char *ptr = utf8;
	for(int i=0;i<length;i++)
	{
		//	ُȃV[PX̌o
		if(*ptr == 0xC0 || *ptr == 0xE0 || *ptr == 0xF0 || *ptr == 0xF8 || *ptr == 0xFC)
		{
			TRACE_U8(_U16("CheckIllegalUTF8: ُUTF8o܂\n"));
			return(TRUE);
		}
		ptr++;
	}
	return(FALSE);
}

/*!
	SăAXL[R[h`FbN
*/
int CUTF8StringTool::CheckAllAscii(LPCSTR mbStr, int mbLength)
{
	//	NULL?
	if(mbStr == NULL)
		return(TRUE);

	//	TCY
	if(mbLength < 0)
		mbLength = strlen((char *)mbStr);

	const unsigned char *ptr = (const unsigned char*)mbStr;
	for(int i=0;i<mbLength;i++)
	{
		//	0x80o
		if(*ptr & 0x80)
		{
			TRACE_U8(_U16("CheckAllAscii: ASCIIȊO̕o܂\n"));
			return(FALSE);
		}
		ptr++;
	}
	return(TRUE);
}


/*!
	UTF8ł\`FbN
	UTF8̃V[PXɈᔽĂȂmF
*/
int CUTF8StringTool::CheckIsUTF8(LPCSTR mbStr, int mbLength)
{
	//	NULL?
	if(mbStr == NULL)
		return(TRUE);

	//	TCY
	if(mbLength < 0)
		mbLength = strlen((char *)mbStr);

	const unsigned char *ptr = (const unsigned char*)mbStr;
	while(*ptr != 0 && ptr - (const unsigned char*)mbStr < mbLength)
	{
		//	0x80o
		if(*ptr & 0x80)
		{
			//	1100 0000
			if((*ptr & 0xe0) == 0xC0)
			{
				//	s
				if(ptr[1] == 0)
					return(FALSE);
				
				//	V[PX̊mF
				if((ptr[1] & 0xC0) != 0x80)
					return(FALSE);
				ptr += 1;
			}
			else if((*ptr & 0xf0) == 0xe0)
			{
				//	s
				if(ptr[1] == 0 || ptr[2] == 0)
					return(FALSE);
				
				//	V[PX̊mF
				if((ptr[1] & 0xC0) != 0x80 || (ptr[2] & 0xC0) != 0x80)
					return(FALSE);
				ptr += 2;
			}
			else if((*ptr & 0xf8) == 0xf0)
			{
				//	s
				if(ptr[1] == 0 || ptr[2] == 0 || ptr[3] == 0)
					return(FALSE);
				
				//	V[PX̊mF
				if((ptr[1] & 0xC0) != 0x80 || (ptr[2] & 0xC0) != 0x80 || (ptr[3] & 0xC0) != 0x80)
					return(FALSE);
				ptr += 3;
			}
			else if((*ptr & 0xfc) == 0xf8)
			{
				//	s
				if(ptr[1] == 0 || ptr[2] == 0 || ptr[3] == 0 || ptr[4] == 0)
					return(FALSE);
				
				//	V[PX̊mF
				if((ptr[1] & 0xC0) != 0x80 || (ptr[2] & 0xC0) != 0x80 || (ptr[3] & 0xC0) != 0x80 || (ptr[4] & 0xC0) != 0x80)
					return(FALSE);
				ptr += 4;
			}
			else if((*ptr & 0xfe) == 0xfc)
			{
				//	s
				if(ptr[1] == 0 || ptr[2] == 0 || ptr[3] == 0 || ptr[4] == 0 || ptr[5] == 0)
					return(FALSE);
				
				//	V[PX̊mF
				if((ptr[1] & 0xC0) != 0x80 || (ptr[2] & 0xC0) != 0x80 || (ptr[3] & 0xC0) != 0x80 || (ptr[4] & 0xC0) != 0x80 || (ptr[5] & 0xC0) != 0x80)
					return(FALSE);
				ptr += 5;
			}
			else
				return(FALSE);
		}
		ptr++;
	}
	return(TRUE);
}



/*!
	UTF8擾
*/
LPCU8STR CUTF8StringTool::MBCSToUTF8(LPCSTR mbStr, int mbLength, CUTF8StringTempBuf &tempBuf)
{
	//	ƃobt@m
	CUTF8StringTempBuf	utf16Buf;

	//	MBCSUTF16֕ϊ
	LPCWSTR				utf16 = AnyToUTF16(mbStr, mbLength, utf16Buf, CP_ACP);

	//	UTF16UTF8
	return(UTF16ToUTF8(utf16, -1, tempBuf));
}


/*!
	UTF8擾
*/
LPCU8STR CUTF8StringTool::UTF16ToUTF8(LPCWSTR u16Str, int u16Length, CUTF8StringTempBuf &tempBuf)
{
	//!	ϊ
	return((LPCU8STR)UTF16ToAny(u16Str, u16Length, tempBuf, CP_UTF8));
}


/*!
	MBCS擾
*/
LPCSTR CUTF8StringTool::UTF8ToMBCS(LPCU8STR u8Str, int u8Length, CUTF8StringTempBuf &tempBuf)
{
	//	ƃobt@m
	CUTF8StringTempBuf	utf16Buf;

	//	UTF8UTF16֕ϊ
	LPCWSTR				utf16 = AnyToUTF16((LPCSTR)u8Str, u8Length, utf16Buf, CP_UTF8);

	//	UTF16MBCS
	return(UTF16ToAny(utf16, -1, tempBuf, CP_ACP));
}

/*!
	UTF16擾
*/
LPCWSTR CUTF8StringTool::UTF8ToUTF16(LPCU8STR u8Str, int u8Length, CUTF8StringTempBuf &tempBuf)
{
	//!	ϊ
	return(AnyToUTF16((LPCSTR)u8Str, u8Length, tempBuf, CP_UTF8));
}


////////////////////////////////////////////////////////////////////////////////
//	ϊ⏕
////////////////////////////////////////////////////////////////////////////////
/*!
	UTF16擾
*/
LPCWSTR CUTF8StringTool::AnyToUTF16(LPCSTR mbStr, int mbLength, CUTF8StringTempBuf &tempBuf, int charSet)
{
	//	TCY
	if(mbLength < 0)
		mbLength = strlen((char *)mbStr);

	//	ϊTCY擾
	int u16Length = ::MultiByteToWideChar(charSet, 0, mbStr, mbLength, NULL, 0);
	if(u16Length == 0)
		return(GetEmptyStringU16());

	//	ƃobt@m
	wchar_t				*utf16 = tempBuf.AllocUTF16(u16Length + 1);

	//	ϊ
	if(::MultiByteToWideChar(charSet, 0, mbStr, mbLength, utf16, u16Length) == 0)
		return(GetEmptyStringU16());

	//	C
	utf16[u16Length] = 0;
	return(utf16);
}


/*!
	UTF8/MBCS擾
*/
LPCSTR CUTF8StringTool::UTF16ToAny(LPCWSTR u16Str, int u16Length, CUTF8StringTempBuf &tempBuf, int charSet)
{
	//	TCY
	if(u16Length < 0)
		u16Length = wcslen(u16Str);

	//	ϊTCY擾
	int mbLength = ::WideCharToMultiByte(charSet, 0, u16Str, u16Length, NULL, 0, NULL, NULL);
	if(mbLength == 0)
		return(GetEmptyStringMB());

	//	obt@m
	LPSTR mbcs = tempBuf.AllocChar(mbLength + 1);

	//	ϊ
	if(::WideCharToMultiByte(charSet, 0, u16Str, u16Length, mbcs, mbLength, NULL, NULL) == 0)
		return(GetEmptyStringMB());

	//	C
	mbcs[mbLength] = 0;
	return(mbcs);
}

////////////////////////////////////////////////////////////////////////////////
//	fobO⏕
////////////////////////////////////////////////////////////////////////////////
/*!
	SăAXL[R[h`FbNA}`oCgꍇASSSERT

	ẽ`FbNɎg
*/
LPU8STR CUTF8StringTool::CheckDirectConvertUTF8(LPCSTR mbStr)
{
	//	}`oCgo
	ASSERT(CheckAllAscii(mbStr, -1));

	return((LPU8STR)mbStr);
}
