/*
	\file	CWorkspace.h
	\brief	KwϐǗNX

	2006/04/05	XMLۑ`̕ύX
	2006/11/14	XMLo͕@ύX
	2009/02/09	UTF8֕ύX
*/

#pragma once
#include "types/WorkspaceTypes.h"
#include "IStringHelper.h"
#include "WorkspaceAccess.h"
#include "SyncObject.h"
#include "InterfaceAutoPtr.h"

//	NX錾
class CWorkspaceNode;
class CWorkspaceLock;
class CWorkspaceAccess;


/*!
	u
*/
class IWorkspaceAutoSwap
{
public:
	//!	ʏ̎擾
	virtual CUTF8String GetKeyDataSwap(IWorkspace *workspace, LPCU8STR orgKey, CUTF8String orgData) = 0;

	//!	폜
	virtual void Delete() = 0;
};
//!	|C^^
typedef IWorkspaceAutoSwap* IWorkspaceAutoSwapPtr;


/*!
	[NXy[X
*/
class CWorkspace : public IWorkspace
{
	friend class CWorkspaceAccess;
	friend class CWorkspaceLock;

public:
	CWorkspace(CUTF8String className = _U8(""));
	virtual ~CWorkspace(void);

	/////////////////////////////////////////////////////////////////////////////////////
	//	ANZX\Ȋ֐
	/////////////////////////////////////////////////////////////////////////////////////
	//!	ANZXNX擾
	CWorkspaceAccess GetAccess(CUTF8String path);

	//!	ANZXNX擾AgNA
	CWorkspaceAccess GetCleanAccess(CUTF8String path);

	/////////////////////////////////////////////////////////////////////////////////////
	//	o͂Ɋւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	XMLt@C֏o
	int SaveToXMLFile(CUTF8String filePath);

	//!	XMLt@C胍[h
	int LoadFromXMLFile(CUTF8String filePath);

	//!	XML֏o
	CUTF8String ToXMLString(CUTF8String savePath = _U8(""));

	//!	XML񂩂琶
	int FromXMLString(CUTF8String xml);


	//!	ʂCWorkspace𕡐
	void Duplicate(CWorkspace &copyFrom, CUTF8String srcPath = _U8(""), CUTF8String destPath = _U8(""));

	/////////////////////////////////////////////////////////////////////////////////////
	//	ݒ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	[hI[
	void SetReadOnly(int readOnly);

	//!	u
	void SetAutoSwap(IWorkspaceAutoSwapPtr autoSwap)
	{
		m_autoSwap = autoSwap;
	};

	//!	u
	void SetAutoSwapDefault(IWorkspaceAutoSwapPtr autoSwap)
	{
		m_autoSwapDefault = autoSwap;
	};

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	Ȃ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Sf[^NA
	virtual void Clear(LPCU8STR path);

	//!	Rs[
	virtual void Copy(LPCU8STR destPath, LPCU8STR srcPath, IWorkspacePtr srcWorkspace = NULL);

	/////////////////////////////////////////////////////////////////////////////////////
	//	r
	/////////////////////////////////////////////////////////////////////////////////////
	//!	bN
	virtual void Lock()
	{
		m_scopeLock.Lock();
	}

	//!	AbN
	virtual void Unlock()
	{
		m_scopeLock.Unlock();
	}

	/////////////////////////////////////////////////////////////////////////////////////
	//	KeyɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	f[^̐ݒ
	virtual void SetKeyData(LPCU8STR path, LPCU8STR data, int noCase = FALSE);

	//!	f[^̎擾
	virtual void GetKeyData(IStringPtr dest, LPCU8STR path, LPCU8STR defaultData, int noCase = FALSE);

	//!	f[^̍폜
	virtual void DeleteKey(LPCU8STR path);

	//!	L[擾
	virtual int GetKeyCount(LPCU8STR path);

	//!	SẴL[𕶎ƂĎ擾
	virtual int GetAllKeyPair(LPCU8STR path, IStringArrayPtr keys, IStringArrayPtr datas);

	/////////////////////////////////////////////////////////////////////////////////////
	//	Tum[hɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	m[h폜
	virtual void DeleteNode(LPCU8STR path);

	//!	Tum[h𓾂
	virtual int GetSubNodeCount(LPCU8STR path);

	//!	SẴTum[h𕶎ƂĎ擾
	virtual int GetAllSubNode(LPCU8STR path, IStringArrayPtr list);


protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	̑̏
	/////////////////////////////////////////////////////////////////////////////////////
	//!	m[hpXɕύX
	CUTF8String ToNodePath(CUTF8String path);

	//!	Tum[h̃|C^擾
	CWorkspaceNode	*GetSubNode(LPCU8STR path, CUTF8String &key = CUTF8String());

	//!	Rs[
	void InternalCopy(CWorkspaceNode *dest, CUTF8String srcPath);

	//!	Rs[(OC^tF[Xp)
	void ExternalCopy(IWorkspace *src, CUTF8String srcPath, CWorkspaceNode *dNode, CIStringArrayWrap &tempKeys, CIStringArrayWrap &tempDatas);

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Ɨ̈̃[g
	CWorkspaceNode			*m_root;

	//!	bNIuWFNg
	CSyncCriticalSection	m_scopeLock;

	//!	NX
	CUTF8String				m_className;

	//!	[hI[
	int						m_readOnly;

	//!	u
	CInterfaceAutoPtr<IWorkspaceAutoSwap>	m_autoSwap;

	//!	u(ftHg)
	CInterfaceAutoPtr<IWorkspaceAutoSwap>	m_autoSwapDefault;

private:
	//!	Rs[֎~
	CWorkspace(const CWorkspace &other);
	void operator=(const CWorkspace &other);
};


/*!
	[NXy[XbNNX
*/
class CWorkspaceLock
{
public:
	CWorkspaceLock(CWorkspaceAccess wa)
	{
		m_ws = wa.GetRoot();
		m_ws->Lock();
	};

	virtual ~CWorkspaceLock()
	{
		m_ws->Unlock();
	};


	IWorkspace	*m_ws;
};

#define	WORKSPACE_LOCK(x) CWorkspaceLock __lock(x);

