#pragma once
#include "types/UTF8Types.h"
#include "UTF8StringTool.h"

///////////////////////////////////////////////////////////////////////////////////
//	ϊpNX
///////////////////////////////////////////////////////////////////////////////////
/*!
	ꎞIUTF8ɕϊ
	LXgɎgA󂯕t̂MBCS/UTF16
	1KoCgAX^bN
	zAXgNXւ̊i[֎~
*/
class CUTF8TempConvert
{
public:
	//!	RXgN^
	CUTF8TempConvert(LPCSTR mbst)
	{
		//	ϊ̕Kv͂邩H
		if(CUTF8StringTool::CheckAllAscii(mbst, -1))
			m_utf8 = (LPCU8STR)mbst;
		else
			m_utf8 = CUTF8StringTool::MBCSToUTF8(mbst, -1, m_utf8Buf);
	}

	//!	RXgN^
	CUTF8TempConvert(LPCWSTR utf16)
	{
		m_utf8 = CUTF8StringTool::UTF16ToUTF8(utf16, -1, m_utf8Buf);
	}

	//!	擾
	operator LPCU8STR()
	{
		return m_utf8;
	}

protected:
	//!	ԊҌԂ
	LPCU8STR			m_utf8;

	//!	ϊp
	CUTF8StringTempBuf	m_utf8Buf;
};



/*!
	ꎞIMBCSɕϊ
	LXgɎgA󂯕t̂UTF8
	1KoCgAX^bN
	zAXgNXւ̊i[֎~
*/
class CMBCSTempConvert
{
public:
	//!	RXgN^
	CMBCSTempConvert(LPCU8STR utf8)
	{
		//	ϊ̕Kv͂邩H
		if(CUTF8StringTool::CheckAllAscii((LPCSTR)utf8, -1))
			m_mbcs = (LPCSTR)utf8;
		else
			m_mbcs = CUTF8StringTool::UTF8ToMBCS(utf8, -1, m_mbcsBuf);
	}

	//!	擾
	operator LPCSTR()
	{
		return m_mbcs;
	}

protected:
	//!	ԊҌԂ
	LPCSTR				m_mbcs;

	//!	ϊp
	CUTF8StringTempBuf	m_mbcsBuf;
};


/*!
	ꎞIUTF16ɕϊ
	LXgɎgA󂯕t̂UTF8
	1KoCgAX^bN
	zAXgNXւ̊i[֎~
*/
class CUTF16TempConvert
{
public:
	//!	RXgN^
	CUTF16TempConvert(LPCU8STR utf16)
	{
		if(utf16 == NULL)
			m_utf16 = NULL;
		else
			m_utf16 = CUTF8StringTool::UTF8ToUTF16(utf16, -1, m_utf16Buf);
	}

	//!	擾
	operator LPCWSTR()
	{
		return m_utf16;
	}

protected:
	//!	ԊҌԂ
	LPCWSTR				m_utf16;

	//!	ϊp
	CUTF8StringTempBuf	m_utf16Buf;
};


///////////////////////////////////////////////////////////////////////////////////
//	ϐ ϊp}N(ϊs)
///////////////////////////////////////////////////////////////////////////////////
//!	UTF8֕ϊ}N
#define	_cnvU8(x)	(LPCU8STR)CUTF8TempConvert(x)

//!	UTF16֕ϊ}N
#define	_cnvU16(x)	(LPCWSTR)CUTF16TempConvert(x)

//!	MBCS֕ϊ}N
#define	_cnvMBCS(x)	(LPCSTR)CMBCSTempConvert(x)


///////////////////////////////////////////////////////////////////////////////////
//	e ϊp}N(ϊsȂ)
///////////////////////////////////////////////////////////////////////////////////
/*!
	UTF8

	ASCIIR[ĥݒڕϊł
	fobOł́A}`oCg̃`FbNs
*/
#define	_U8(x)		CUTF8StringTool::CheckDirectConvertUTF8(x)

/*!
	UTF16

	ChoCgŐ錾
*/
#define _U16(x)      L ## x
