#include "StdAfx.h"
#include "TextTools.h"

//////////////////////////////////////////////////////////////////////
// C؂o
//////////////////////////////////////////////////////////////////////
int CTextTools::GetLine(CUTF8String &str, CUTF8String &line)
{
	int index = str.Find(_U8("\r\n"));

	if(index == -1)
	{
		if(str.IsEmpty())
			return(0);

		line = str;
		str.Empty();
		return(1);
	}
	
	//	؂o
	line = str.Left(index);

	//	폜
	str = str.Mid(index + 2);
	return(1);
}

//////////////////////////////////////////////////////////////////////
// g[N؂o
//////////////////////////////////////////////////////////////////////
int CTextTools::GetToken(CUTF8String &str, CUTF8String &token, CUTF8String div, int trim)
{
	int tlen = div.GetLength();
	int index = str.Find(div);

	if(index == -1)
	{
		if(str.IsEmpty())
			return(0);

		token = str;
		if(trim)
			token.Trim();
		str.Empty();
		return(1);
	}
	
	//	؂o
	token = str.Left(index);
	if(trim)
		token.Trim();

	//	폜
	str = str.Mid(index + tlen);
	return(1);
}


/*!
	g[NSĐ؂o
*/
void CTextTools::GetAllToken(CUTF8String str, CUTF8StringArray &tokens, CUTF8String div, int trim)
{
	tokens.RemoveAll();

	CUTF8String token;
	while(GetToken(str, token, div))
		tokens.Add(token);
}


//////////////////////////////////////////////////////////////
//	ChJ[hr
//////////////////////////////////////////////////////////////
/*!
	ChJ[hŔr

	\return TRUE->v
*/
int CTextTools::WildCompare(CUTF8String wild, CUTF8String str)
{
	//	O
	wild.MakeLower();
	str.MakeLower();

	return(StrMatch(wild, str));
}

/*!
	
*/
int CTextTools::StrMatch(LPCU8STR Ptn, LPCU8STR Str )
{
	switch( *Ptn )
	{
		case '\0':
			return (*Str=='\0');
		case '*':
			return StrMatch( Ptn+1, Str ) || (*Str!='\0') && StrMatch( Ptn, Str+1 );
		case '?':
			return (*Str!='\0') && StrMatch( Ptn+1, Str+1 );
		default:
			return ((unsigned char)*Ptn==(unsigned char)*Str) && StrMatch( Ptn+1, Str+1 );
	}
}


//////////////////////////////////////////////////////////////
//	z񏈗
//////////////////////////////////////////////////////////////
/*!
	z񂩂當
*/
int CTextTools::FindStrIndex(CUTF8StringArray &list, CUTF8String find, int noCase)
{
	for(int i=0;i<list.GetCount();i++)
	{
		if(noCase)
		{
			if(list[i].CompareNoCase(find) == 0)
				return(i);
		}
		else
		{
			if(list[i] == find)
				return(i);
		}
	}

	return(-1);
}

//////////////////////////////////////////////////////////////
//	 <-> lϊ
//////////////////////////////////////////////////////////////
/*!
	𐔒l
*/
long CTextTools::StrTol(CUTF8String str, int radix)
{
	return strtol(_cnvMBCS(str), NULL, radix);
}

/*!
	l𕶎
*/
CUTF8String CTextTools::ltoStr(long num, int radix)
{
	utf8_char	str[80];

	_ltoa_s(num, (LPSTR)str, 80, radix);
	return(str);
}
