/*!
	DirTools.h

	fBNg֌W̏s

	Version		: 2.0 (Release2)
	Version		: 2.0 (Release2)
			: t@ČpX̏Ȃ


	쐬		: 2000/12/07
	C		: 2009/02/10
	藚	: 2006/02/10 |EEE
	藚	: 2009/02/10 UTF8
*/
#pragma once
#include "Time_t.h"


/*!
	fBNgsNX
*/
class CDirIndexer
{
public:
	CDirIndexer();
	virtual ~CDirIndexer();

	///////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////
	//!	t@Čs
	int StartFind(CUTF8String fileName);

	//!	
	int FindNext();

	//!	I
	void CloseFind();

	///////////////////////////////////////////////////////////////////////
	//	ʂւ̃ANZX(O)
	///////////////////////////////////////////////////////////////////////
	//!	݂̃t@C
	CUTF8String GetFileName() { return m_currentEntry.cFileName; }

	//!	݂̃pX
	CUTF8String GetFilePath() { return m_findPath + GetFileName(); }

	///////////////////////////////////////////////////////////////////////
	//	ʂւ̃ANZX(TCYA)
	///////////////////////////////////////////////////////////////////////
	//!	t@CTCY
	__int64 GetFileSize() { return (__int64)m_currentEntry.nFileSizeHigh << 32 | (__int64)m_currentEntry.nFileSizeLow; }

	//!	XV
	CTime_t GetCreationTime() { return m_currentEntry.ftCreationTime; }

	//!	XV
	CTime_t GetLastWriteTime() { return m_currentEntry.ftLastWriteTime; }

	//!	ANZX
	CTime_t GetLastAccessTime() { return m_currentEntry.ftLastAccessTime; }

	///////////////////////////////////////////////////////////////////////
	//	ʂւ̃ANZX()
	///////////////////////////////////////////////////////////////////////
	//!	fBNg
	int IsDirectory() { return(m_currentEntry.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY); }

	//!	\
	int IsHidden() { return(m_currentEntry.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN); }

	//!	ǂݍݐp
	int IsReadonly() { return(m_currentEntry.dwFileAttributes & FILE_ATTRIBUTE_READONLY); }

	//!	./..
	int IsDots() { return(wcscmp(m_currentEntry.cFileName, _U16(".")) == 0 || wcscmp(m_currentEntry.cFileName, _U16("..")) == 0); }

protected:
	///////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////
	//!	nh
	HANDLE 				m_hFind;

	//!	݂̃Gg
	WIN32_FIND_DATA		m_currentEntry;

	//!	pX
	CUTF8String			m_findPath;
};


/*!
	t@CEfBNg֌W̃c[S
*/
class CFileDirTools
{
public:
	///////////////////////////////////////////////////////////////////////
	//	t@C
	///////////////////////////////////////////////////////////////////////
	//!	t@C̑擾
	static DWORD GetFileAttribute(CUTF8String path);

	//!	t@C̑݃`FbN
	static int FileExist(CUTF8String path);

	///////////////////////////////////////////////////////////////////////
	//	fBNg
	///////////////////////////////////////////////////////////////////////
	//!	pX⊮(݂ȂfBNgSč쐬)
	static int MakeAllDirectory(CUTF8String path);

	//!	fBNg݂̑mFA݂Ȃ琶
	static int MakeDirectory(CUTF8String path);

	///////////////////////////////////////////////////////////////////////
	//	萔
	///////////////////////////////////////////////////////////////////////
	//!	FileExist萔
	enum FILE_EXIST_TYPE
	{
		FILE_TYPE_FILE		= 1,
		FILE_TYPE_DIRECTORY = 2,
		FILE_TYPE_NOTFOUND	= 0
	};

	//!	t@C
	enum
	{
		FILE_ATTR_NORMAL	= FILE_ATTRIBUTE_NORMAL,
		FILE_ATTR_READONLY	= FILE_ATTRIBUTE_READONLY,
		FILE_ATTR_HIDDEN	= FILE_ATTRIBUTE_HIDDEN,
		FILE_ATTR_SYSTEM	= FILE_ATTRIBUTE_SYSTEM,
		FILE_ATTR_DIRECTORY	= FILE_ATTRIBUTE_DIRECTORY,
		FILE_ATTR_ARCHIVE	= FILE_ATTRIBUTE_ARCHIVE,
		FILE_ATTR_COMPRESSED= FILE_ATTRIBUTE_COMPRESSED,
		FILE_ATTR_ENCRYPTED	= FILE_ATTRIBUTE_ENCRYPTED,
		FILE_ATTR_ERROR		= INVALID_FILE_ATTRIBUTES,
	};
};

class CPathTools
{
public:
	///////////////////////////////////////////////////////////////////////
	//	pXϊ
	///////////////////////////////////////////////////////////////////////
	//!	hCu̎擾
	static CUTF8String PathToDrive(CUTF8String path);

	//!	fBNgpX̎擾
	static CUTF8String PathToDir(CUTF8String path);

	//!	t@C̎擾
	static CUTF8String PathToName(CUTF8String path);

	//!	t@C̎擾(gqȂ)
	static CUTF8String PathToNameNoExt(CUTF8String path);

	//!	t@Cgq̎擾
	static CUTF8String PathToExt(CUTF8String path);

	//!	ЂƂ̃fBNgpX擾
	static CUTF8String GetUpDir(CUTF8String path);

	//!	gȂu
	static CUTF8String SafeName(CUTF8String name, CUTF8String replace = _U8("_"));

	//!	\it@C or tH_ or hCuj擾
	static CUTF8String PathToViewName(CUTF8String name);

	//!	32KpXLɂi"\\?\"ǉj
	static CUTF8String AddLongPathPrefix(CUTF8String path);

	///////////////////////////////////////////////////////////////////////
	//	pX̔r
	///////////////////////////////////////////////////////////////////////
	//!	pXɊ܂܂Ă邩ׂ
	static int IsInPath(CUTF8String parentPath, CUTF8String childPath);

	///////////////////////////////////////////////////////////////////////
	//	/\̉H
	///////////////////////////////////////////////////////////////////////
	//!	XbVɒǉ
	static CUTF8String AddSlash(CUTF8String path);

	//!	obNXbVɒǉ
	static CUTF8String AddBackSlash(CUTF8String path);

	//!	XbV납폜
	static CUTF8String RemoveSlash(CUTF8String path);

	//!	obNXbV납폜
	static CUTF8String RemoveBackSlash(CUTF8String path);

	//!	ŌɃXbV邩
	static int CheckSlash(CUTF8String path);
	
	//!	ŌɃobNXbV邩
	static int CheckBackSlash(CUTF8String path);
	
	//!	Ō̕`FbN
	static int CheckLastChar(CUTF8String path, unsigned char c);

	///////////////////////////////////////////////////////////////////////
	//	W[pX
	///////////////////////////////////////////////////////////////////////
	//!	W[pX擾
	static CUTF8String GetAppPath();

	//!	W[pX擾
	static CUTF8String GetAppPathName();

	/////////////////////////////////////////////////////////////////////////
	//	epX擾
	/////////////////////////////////////////////////////////////////////////
	//!	pXϐũpX擾
	static CUTF8String GetPathSwapString(CUTF8String path);

	//!	Windows pX擾
	static CUTF8String GetWindowsPath();

	//!	System32 pX擾
	static CUTF8String GetSystem32Path();

	//!	Program Files pX擾
	static CUTF8String GetProgramFilesPath();

	//!	All Users/Application Data pX擾
	static CUTF8String GetCommonAppDataPath();
};
