#pragma once

#include "IServerTool.h"
#include "InterfaceManager.h"

#include "SettingManager.h"
#include "ServerStatusManager.h"
#include "ListenerManager.h"
#include "ConnectionThreadManager.h"

/*
#include "NewConnectionQueue.h"
#include "ResponseManager.h"
#include "FilterManager.h"
#include "SupportManagers.h"
*/

/*!
	T[opC^tF[X
*/
class IServerControl
{
public:
	//!	T[o̊Jn
	virtual void StartServer() = 0;

	//!	T[o̒~
	virtual void StopServer() = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	̎擾
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ReLXg擾
	virtual void DuplicateCurrentContext(CWorkspace &contextRoot) = 0;

	//!	T[oXe[^X擾
	virtual void DuplicateServerStatus(CWorkspace &statusRoot) = 0  ;
};
//!	|C^^
typedef IServerControl* IServerControlPtr;


/*!
	T[o{
*/
class CServer : protected IServerTool, protected IServerControl
{
public:
	CServer(void);
	virtual ~CServer(void);

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerControlC^[tF[X擾
	IServerControlPtr GetIServerControl() { return this; };

	//!	fobO
	void Dump();

protected:
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerToolC^[tF[X擾
	IServerToolPtr GetIServerTool() { return this; };

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerControl
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[o̊Jn
	virtual void StartServer();

	//!	T[o̒~
	virtual void StopServer();

	//!	ReLXg擾
	virtual void DuplicateCurrentContext(CWorkspace &contextRoot);

	//!	T[oXe[^X擾
	virtual void DuplicateServerStatus(CWorkspace &statusRoot);


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerTool
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oXe[^X̕ύX
	virtual void WriteSystemLog(LPCU8STR callerName, int logType, LPCU8STR logString);

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatus(LPCU8STR statusName, LPCU8STR status, LPCU8STR statusInfo = _U8(""), LPCU8STR statusType = _U8("String"));

	//!	T[obZ[Wʒm
	virtual void NotifyServerMessage(LPCU8STR messageID, LPCU8STR message, int messageType, int autoOffTimeSec = -1);


	//!	[NXy[Xւ̃ANZX擾
	virtual int GetServerWorkspaceAccess(IWorkspaceAccessRefPtr accessRef, LPCU8STR type, LPCU8STR section);


	//!	C^tF[Xo^
	virtual int RegisterManagerInterface(LPCU8STR interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface);

	//!	C^[tF[Xo^
	virtual int UnRegisterManagerInterface(LPCU8STR interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface);

	//!	C^tF[Xw肵Ď擾
	virtual void *GetManagerInterface(LPCU8STR managerName, int interfaceVersion);


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	ʃNX
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X}l[W
	CInterfaceManager		m_interfaceManager;

	//!	ݒ}l[W
	CSettingManager			m_settingManager;

	//!	Xe[^X}l[W
	CServerStatusManager	m_statusManager;
/*
	//!	⏕}l[W
	CSupportManagers		m_supportManagers;

*/

	//!	Xi
	CListenerManager		m_listenerManager;

	//!	ڑ}l[W
	CConnectionThreadManager	m_connectionManager;

	/*
	//!	X|X}l[W
	CResponseManager		m_responseManager;

	//!	tB^}l[W
	CFilterManager			m_filterManager;

*/

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[os
	CInterlockCounter		m_serverRunning;
};
