#pragma once
#include "Workspace.h"

/*!
	Workspace List ̃\[gsx[XNX
*/
class CWorkspaceListAccessSortBase
{
public:
	virtual int IsBefore(CWorkspaceAccess from, CWorkspaceAccess to) = 0;
};

/*!
	Workspace List ̃\[gsNX
*/
class CWorkspaceListAccessSimpleSort : public CWorkspaceListAccessSortBase
{
public:
	virtual int IsBefore(CWorkspaceAccess from, CWorkspaceAccess to);

	CStringArray	m_keyName;
};

/*!
	Workspace List
*/
class CWorkspaceListAccess : public CWorkspaceAccess
{
public:
	CWorkspaceListAccess(CString listName);
	CWorkspaceListAccess(CWorkspaceAccess &other, CString listName);
	virtual ~CWorkspaceListAccess(void);

	//!	CWorkspaceAccess ݒ
	void operator = (CWorkspaceAccess &other) {	CWorkspaceAccess::operator=(other); }

	//////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////
	//!	̎擾
	int GetItemCount();

	//!	ACe̎擾
	CWorkspaceAccess GetItem(int index);

	//!	ACeǉ
	CWorkspaceAccess GetNewItem();

	//!	ACe̍폜
	void DeleteItem(CWorkspaceAccess item);

	//!	ACe̍폜
	void DeleteItem(int index);

	//////////////////////////////////////////////////////////////////////////////
	//	\[g
	//////////////////////////////////////////////////////////////////////////////
	//!	\[g
	void Sort(CWorkspaceListAccessSortBase *sortBase);

	//!	\[g(L[e)
	void Sort(CString key1, CString key2=_T(""), CString key3=_T(""));

protected:
	/////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////
	//!	O
	CString			m_listName;
};



/*!
	X^eBbNev[g
*/
template<	char s0=0, char s1=0, char s2=0, char s3=0, 
			char s4=0, char s5=0, char s6=0, char s7=0, 
			char s8=0, char s9=0, char s10=0, char s11=0, 
			char s12=0, char s13=0, char s14=0, char s15=0 >
class CWTLAName
{
public:
	CWTLAName()
	{
		if(s0 != 0)
			m_name += s0;
		else
			return;
		if(s1 != 0)
			m_name += s1;
		else
			return;
		if(s2 != 0)
			m_name += s2;
		else
			return;
		if(s3 != 0)
			m_name += s3;
		else
			return;

		if(s4 != 0)
			m_name += s4;
		else
			return;
		if(s5 != 0)
			m_name += s5;
		else
			return;
		if(s6 != 0)
			m_name += s6;
		else
			return;
		if(s7 != 0)
			m_name += s7;
		else
			return;

		if(s8 != 0)
			m_name += s8;
		else
			return;
		if(s9 != 0)
			m_name += s9;
		else
			return;
		if(s10 != 0)
			m_name += s10;
		else
			return;
		if(s11 != 0)
			m_name += s11;
		else
			return;

		if(s12 != 0)
			m_name += s12;
		else
			return;
		if(s13 != 0)
			m_name += s13;
		else
			return;
		if(s14 != 0)
			m_name += s14;
		else
			return;
		if(s15 != 0)
			m_name += s15;
		else
			return;
	};

	//	擾ꂽ
	CString	m_name;
};

/*!
	Workspace List
*/
template<class TYPE, class STATIC_NAME>
class CWorkspaceTypedListAccess : public CWorkspaceListAccess
{
public:
	CWorkspaceTypedListAccess()
		: CWorkspaceListAccess(STATIC_NAME().m_name) {};
	CWorkspaceTypedListAccess(CWorkspaceAccess &other)
		 : CWorkspaceListAccess(other, STATIC_NAME().m_name) {};

	//!	CWorkspaceAccess ݒ
	void operator = (CWorkspaceAccess &other) {	CWorkspaceListAccess::operator=(other); }

	//////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////
	//!	ACe̎擾
	TYPE GetItem(int index) { return CWorkspaceListAccess::GetItem(index); };

	//!	ACeǉ
	TYPE GetNewItem() { return CWorkspaceListAccess::GetNewItem(); };
};
