#pragma once
#include "ModuleInterface.h"
#include "ServerToolWrap.h"
#include "Context.h"
#include "SyncObject.h"
#include "SimpleManagerInterfaceImplement.h"

//!	C^tF[X
#define	RESPONSE_MANAGER_INTERFACE_NAME	"IResponseManager"

//!	C^tF[Xo[W
#define	RESPONSE_MANAGER_INTERFACE_VER	1


/*!
	X|XǗ
*/
class IResponseManager
{
public:
	//!	X|X
	virtual IResponsePtr GetResponse(CContext context) = 0;
};
//!	|C^^
typedef IResponseManager* IResponseManagerPtr;


/*!
	X|XǗ
*/
class CResponseManager : public IResponseManager
{
public:
	CResponseManager(void);
	virtual ~CResponseManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|Xt@NgǗNX
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xt@NgǗNX
	class CResponseFactoryArrayItem
	{
	public:
		//!	RXgN^
		CResponseFactoryArrayItem()
		{
		}

		//!	RXgN^
		CResponseFactoryArrayItem(CIResponseFactoryWrapper factory, int responseLevel)
		{
			m_responseFactory = factory;
			m_responseLevel = responseLevel;
		}

		//////////////////////////////////////////////////////////////////////////////////////////////
		//	bp
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	x擾
		int GetResponseLevel()
		{
			return m_responseLevel;
		}

		//!	
		void Start(IServerToolPtr serverTool)
		{
			m_responseFactory->Start(serverTool);
		}

		//!	~
		void Stop()
		{
			m_responseFactory->Stop();
		}

		//!	̃ACeH
		int IsYourRequest(IWorkspaceAccessPtr context)
		{
			return m_responseFactory->IsYourRequest(context);
		}

		//!	X|X擾
		IResponsePtr GetResponse()
		{
			return m_responseFactory->GetResponse();
		}

	protected:
		//////////////////////////////////////////////////////////////////////////////////////////////
		//	oϐ
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	X|Xt@Ng
		CIResponseFactoryWrapper	m_responseFactory;

		//!	D揇
		int							m_responseLevel;
	};

	//!	X|Xt@NgAC
	class CResponseFactoryArray : public CArray<CResponseFactoryArrayItem> {};

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	IResponseManager
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|X
	IResponsePtr GetResponse(CContext context);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	{X|Xǉ
	void AddBasicResponses();

	//!	X|Xǉ
	void AddResponsesFactory(IResponseFactoryPtr factory, int responseLevel);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter					m_init;

	//!	NeBJZNV
	CCriticalSection					m_scopeLock;

	//!	T[oc[
	CIServerToolWrap					m_serverTool;

	//!	C^tF[X
	CSimpleManagerInterfaceImplement	m_managerInterface;

	//!	t@Ng
	CResponseFactoryArray				m_responseFactorys;
};
