#include "StdAfx.h"
#include "KeepAliveFilter.h"

#include "TextTools.h"

//!	W[
static TCHAR _MODULE_NAME[] = _T("KeepAliveFilter");

CKeepAliveFilter::CKeepAliveFilter(void)
{
}

CKeepAliveFilter::~CKeepAliveFilter(void)
{
}



/*!
	tB^擾
*/
LPCTSTR CKeepAliveFilter::GetFilterName()
{
	return _MODULE_NAME;
};

/*!
	
*/
void CKeepAliveFilter::Init(CIServerToolWrap serverTool)
{
	//	Rs[A
	m_serverTool = serverTool;

	//	ݒ擾
	m_setting = m_serverTool.GetFilterSetting(m_setting.GetSettingName());
	m_enableKeepAlive = m_setting.GetEnableKeepAlive();
	m_keepAliveTime = m_setting.GetMaxKeepConnectionTime();
	m_keepAliveCount = m_setting.GetMaxKeepConnectionCount();
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	NGXgM
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgwb_
*/
void CKeepAliveFilter::FilterRequestHeader(CIConnectionToolWrap filterContext)
{
	//	NGXgIvV擾
	CContextRequestInfo		requestInfo = filterContext.GetContxet().GetRequestInfo();
	CContextRequestOption	requestOption = requestInfo.GetRequestOption();

	//	KeepAlivewH
	if(m_enableKeepAlive && requestOption.GetConnection().CompareNoCase("keep-alive") == 0)
		filterContext.GetIConnectionControl()->SetReuseConnection(TRUE);
	else
		filterContext.GetIConnectionControl()->SetReuseConnection(FALSE);
}



//////////////////////////////////////////////////////////////////////////////////////////////
//	X|XM
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	X|Xwb_
*/
void CKeepAliveFilter::FilterResponseHeader(CIConnectionToolWrap filterContext)
{
	//	X|XIvV擾
	CContextResponseInfo	responseInfo = filterContext.GetContxet().GetResponseInfo();
	CContextResponseOption	responseOption = responseInfo.GetResponseOption();

	//	KeepAlive\H
	if(filterContext.GetIConnectionControl()->CanReuseConnection())
	{
		responseOption.SetConnection("Keep-Alive");
		responseOption.SetKeepAlive(CTextTools::GetFormat("timeout=%d, max=%d", m_keepAliveTime / 1000, m_keepAliveCount));
	}
	else
	{
		responseOption.SetConnection("Close");
		responseOption.ClearKeepAlive();
	}
}


