#pragma once
#include "ifilter.h"
#include "ServerToolWrap.h"
#include "BinaryData.h"
#include "ConnectionToolWrap.h"


/*!
	tB^t@Ng@x[X
*/
class CFilterFactoryBase
{
public:
	//!	RXgN^
	CFilterFactoryBase(void)
	{
		m_interface.SetFilterFactoryBase(this);
	}

	//!	fXgN^
	virtual ~CFilterFactoryBase(void)
	{
	}

	//!	C^tF[X擾
	IFilterFactoryPtr GetIFilterFactory()
	{
		return &m_interface;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void Start(CIServerToolWrap serverTool) {};

	//!	~
	virtual void Stop() {};

	//!	폜
	virtual void Delete() {};

	//!	擾
	virtual IFilterPtr GetFilter() = 0;

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	tB^C^tF[X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^C^tF[X
	class CFilterFactoryInterface :	public IFilterFactory
	{
	public:
		CFilterFactoryInterface()
		{
			m_filterFactory = NULL;
		}

		//!	Zbg
		void SetFilterFactoryBase(CFilterFactoryBase *filterFactory)
		{
			m_filterFactory = filterFactory;
		}

		//!	
		virtual void Start(IServerToolPtr serverTool)
		{
			m_filterFactory->Start(serverTool);
		}

		//!	~
		virtual void Stop()
		{
			m_filterFactory->Stop();
		}

		//!	폜
		virtual void Delete()
		{
			m_filterFactory->Delete();
		}

		//!	tB^擾
		virtual IFilterPtr GetFilter()
		{
			return m_filterFactory->GetFilter();
		}

	protected:
		//////////////////////////////////////////////////////////////////////////////////////////////
		//	oϐ
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	
		CFilterFactoryBase	*m_filterFactory;
	};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X
	CFilterFactoryInterface	m_interface;
};



/*!
	tB^x[X
*/
class CFilterBase
{
public:
	//!	RXgN^
	CFilterBase(void)
	{
		m_interface.SetFilterBase(this);
	};

	//!	fXgN^
	virtual ~CFilterBase(void)
	{
	};

	//!	C^tF[X擾
	IFilterPtr GetIFilter()
	{
		return &m_interface;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void Start(CIConnectionToolWrap filterContext) {};

	//!	ؒf
	virtual void Stop(CIConnectionToolWrap filterContext) {};

	//!	폜
	virtual void Delete() {};

	//!	tB^擾
	virtual LPCTSTR GetFilterName() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	tB^O
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	1:NGXgwb_
	virtual void FilterRequestHeader(CIConnectionToolWrap filterContext) {};

	//!	2:{fBMAJԂ(throw)
	virtual void FilterRequestBody(CIConnectionToolWrap filterContext, CBinaryData &body) {};

	//!	3:M
	virtual void FilterEndRequest(CIConnectionToolWrap filterContext) {};


	//!	4:X|X
	virtual void FilterBuildResponse(CIConnectionToolWrap filterContext) {};


	//!	5:X|Xwb_
	virtual void FilterResponseHeader(CIConnectionToolWrap filterContext) {};

	//!	6:{fB𑗐MAJԂ(throw)
	virtual void FilterResponseBody(CIConnectionToolWrap filterContext, CBinaryData &body) {};

	//!	7:M
	virtual void FilterEndResponse(CIConnectionToolWrap filterContext) {};


	//!	X|Xwb_(OցI)
	virtual void FilterServerResponse(CIConnectionToolWrap filterContext, CBinaryData &body) {};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	tB^C^tF[X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^C^tF[X
	class CFilterInterface : public IFilter
	{
	public:
		//!	RXgN^
		CFilterInterface()
		{
			m_filterBase = NULL;
		}

		//!	Zbg
		void SetFilterBase(CFilterBase *filterBase)
		{
			m_filterBase = filterBase;
		}

		//!	
		virtual void Start(IConnectionToolPtr filterContext)
		{
			m_filterBase->Start(filterContext);
		}

		//!	ؒf
		virtual void Stop(IConnectionToolPtr filterContext)
		{
			m_filterBase->Stop(filterContext);
		}

		//!	폜
		virtual void Delete()
		{
			m_filterBase->Delete();
		}

		//!	tB^擾
		virtual LPCTSTR GetFilterName()
		{
			return m_filterBase->GetFilterName();
		}

		//!	NGXgwb_
		virtual void FilterRequestHeader(IConnectionToolPtr filterContext)
		{
			m_filterBase->FilterRequestHeader(filterContext);
		}

		//!	{fBMAJԂ(throw)
		virtual void FilterRequestBody(IConnectionToolPtr filterContext, IBinaryDataPtr body)
		{
			m_filterBase->FilterRequestBody(filterContext, CBinaryData(body));
		}

		//!	M
		virtual void FilterEndRequest(IConnectionToolPtr filterContext)
		{
			m_filterBase->FilterEndRequest(filterContext);
		}

		//!	X|X
		virtual void FilterBuildResponse(IConnectionToolPtr filterContext)
		{
			m_filterBase->FilterBuildResponse(filterContext);
		}

		//!	X|Xwb_
		virtual void FilterResponseHeader(IConnectionToolPtr filterContext)
		{
			m_filterBase->FilterResponseHeader(filterContext);
		}

		//!	{fB𑗐MAJԂ(throw)
		virtual void FilterResponseBody(IConnectionToolPtr filterContext, IBinaryDataPtr body)
		{
			m_filterBase->FilterResponseBody(filterContext, CBinaryData(body));
		}

		//!	M
		virtual void FilterEndResponse(IConnectionToolPtr filterContext)
		{
			m_filterBase->FilterEndResponse(filterContext);
		}

		//!	X|Xwb_(OցI)
		virtual void FilterServerResponse(IConnectionToolPtr filterContext, IBinaryDataPtr body)
		{
			m_filterBase->FilterServerResponse(filterContext, CBinaryData(body));
		}

	protected:
		//////////////////////////////////////////////////////////////////////////////////////////////
		//	oϐ
		//////////////////////////////////////////////////////////////////////////////////////////////
		//!	
		CFilterBase	*m_filterBase;
	};
	
protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X
	CFilterInterface	m_interface;
};
